/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.idea.AppMode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.tables.JupyterTableOutputDataKey;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableText;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001aA\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"getTableDataText", "Lcom/intellij/scientific/tables/api/DSTableText;", "tableDataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getTableOutputDataKey", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "executionCount", "", "isLastForCell", "", "type", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/Integer;ZLcom/intellij/scientific/tables/api/DSTableDataType;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "createTableOutputDataKey", "text", "(Lcom/intellij/scientific/tables/api/DSTableText;Lcom/intellij/scientific/tables/api/DSTableDataType;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Integer;Z)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "intellij.jupyter.tables"})
public final class ExtractingKt {
    @Nullable
    public static final DSTableText getTableDataText(@NotNull DSTableDataType tableDataType, @NotNull ObjectNode dataObject) {
        Intrinsics.checkNotNullParameter((Object)tableDataType, (String)"tableDataType");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        return switch (WhenMappings.$EnumSwitchMapping$0[tableDataType.ordinal()]) {
            case 1, 2, 3, 4 -> ExtractingKt.getTableDataText$getTableText(dataObject, MimeType.TEXT_HTML.getMimeType(), MimeType.TEXT_PLAIN.getMimeType());
            case 5, 6, 7, 8, 9, 10, 11, 12 -> ExtractingKt.getTableDataText$getTableText(dataObject, MimeType.TEXT_PLAIN.getMimeType(), MimeType.TEXT_PLAIN.getMimeType());
            case 13 -> ExtractingKt.getTableDataText$getTableText(dataObject, "text", "text");
            case 14 -> null;
            case 15 -> null;
            case 16 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final NotebookOutputDataKey getTableOutputDataKey(@NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer, @NotNull ObjectNode dataObject, @Nullable Integer executionCount, boolean isLastForCell, @Nullable DSTableDataType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        if (type == null) {
            return null;
        }
        if (AppMode.isRemoteDevHost()) {
            return null;
        }
        DSTableText dSTableText = ExtractingKt.getTableDataText(type, dataObject);
        if (dSTableText == null) {
            return null;
        }
        DSTableText text = dSTableText;
        return ExtractingKt.createTableOutputDataKey(text, type, editor, cellPointer, executionCount, isLastForCell);
    }

    @Nullable
    public static final NotebookOutputDataKey createTableOutputDataKey(@NotNull DSTableText text, @NotNull DSTableDataType type, @NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer, @Nullable Integer executionCount, boolean isLastForCell) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        BackedNotebookVirtualFile notebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor);
        JupyterNotebookSession session = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession(notebookVirtualFile);
        boolean createNewComponent = session == null ? false : isLastForCell && session.getMessageTracker().shouldRequestNewAsyncComponent(cellPointer);
        return new JupyterTableOutputDataKey(text, executionCount, type, interval2.getOrdinal(), createNewComponent);
    }

    private static final DSTableText getTableDataText$getTableText(ObjectNode $dataObject, String staticTableKey, String plainTextKey) {
        JsonNode jsonNode = $dataObject.get(staticTableKey);
        if (jsonNode == null) {
            return null;
        }
        JsonNode staticTableData = jsonNode;
        JsonNode jsonNode2 = $dataObject.get(plainTextKey);
        if (jsonNode2 == null) {
            return null;
        }
        JsonNode plainTextData = jsonNode2;
        return new DSTableText(com.intellij.jupyter.core.jupyter.editor.outputs.util.ExtractingKt.elementToString$default((JsonNode)staticTableData, null, (int)2, null), com.intellij.jupyter.core.jupyter.editor.outputs.util.ExtractingKt.elementToString$default((JsonNode)plainTextData, null, (int)2, null));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DSTableDataType.values().length];
            try {
                nArray[DSTableDataType.PANDAS_DATA_FRAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.GENERIC_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.POLARS_DATA_FRAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.POLARS_SERIES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.PANDAS_SERIES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NUMPY_ARRAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NUMPY_RECARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.EAGER_TENSOR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.RESOURCE_VARIABLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.SPARSE_TENSOR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.TORCH_TENSOR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.HF_DATASET.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.PYSPARK_TABLE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.EXTERNAL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.NOT_ANY.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DSTableDataType.KOTLIN_DATAFRAME.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

