/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedCostContainer;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkContainer;
import net.sf.mpxj.common.DefaultTimephasedCostContainer;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TimephasedCostNormaliser;
import net.sf.mpxj.common.TimephasedWorkNormaliser;
import net.sf.mpxj.mpp.MPPUtility;

final class TimephasedDataFactory {
    TimephasedDataFactory() {
    }

    public List<TimephasedWork> getCompleteWork(ProjectCalendar projectCalendar, ResourceAssignment resourceAssignment, byte[] byArray) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        if (projectCalendar != null && byArray != null && byArray.length > 0) {
            Date date = resourceAssignment.getStart();
            double d = MPPUtility.getInt(byArray, 24);
            int n = MPPUtility.getShort(byArray, 0);
            double d2 = 0.0;
            TimephasedItem timephasedItem = null;
            int n2 = 32;
            for (int i = 0; i < n && n2 + 20 <= byArray.length; ++i) {
                double d3 = MPPUtility.getInt(byArray, n2 + 0);
                d3 = d3 < 0.0 || d3 > d ? 0.0 : (d3 /= 80.0);
                Duration duration = Duration.getInstance(d3, TimeUnit.MINUTES);
                double d4 = (long)MPPUtility.getDouble(byArray, n2 + 4);
                double d5 = d4 - d2;
                d2 = d4;
                Duration duration2 = Duration.getInstance(d5 /= 1000.0, TimeUnit.MINUTES);
                d3 = (long)MPPUtility.getDouble(byArray, n2 + 12);
                d3 /= 125.0;
                Duration duration3 = Duration.getInstance(d3 *= 6.0, TimeUnit.MINUTES);
                Date date2 = duration.getDuration() == 0.0 ? date : projectCalendar.getDate(date, duration, true);
                TimephasedWork timephasedWork = new TimephasedWork();
                timephasedWork.setStart(date2);
                timephasedWork.setAmountPerDay(duration3);
                timephasedWork.setTotalAmount(duration2);
                if (timephasedItem != null) {
                    Date date3 = projectCalendar.getDate(date, duration, false);
                    timephasedItem.setFinish(date3);
                    if (timephasedItem.getStart().getTime() == timephasedItem.getFinish().getTime()) {
                        linkedList.removeLast();
                    }
                }
                linkedList.add(timephasedWork);
                timephasedItem = timephasedWork;
                n2 += 20;
            }
            if (timephasedItem != null) {
                Duration duration = Duration.getInstance(d / 80.0, TimeUnit.MINUTES);
                Date date4 = projectCalendar.getDate(date, duration, false);
                timephasedItem.setFinish(date4);
                if (timephasedItem.getStart().getTime() == timephasedItem.getFinish().getTime()) {
                    linkedList.removeLast();
                }
            }
        }
        return linkedList;
    }

    public List<TimephasedWork> getPlannedWork(ProjectCalendar projectCalendar, Date date, double d, byte[] byArray, List<TimephasedWork> list) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        if (projectCalendar != null && byArray != null && byArray.length > 0) {
            int n = MPPUtility.getShort(byArray, 0);
            if (n == 0) {
                if (!list.isEmpty() && d != 0.0) {
                    TimephasedWork timephasedWork = list.get(list.size() - 1);
                    Date date2 = projectCalendar.getNextWorkStart(timephasedWork.getFinish());
                    double d2 = MPPUtility.getDouble(byArray, 16);
                    Duration duration = Duration.getInstance(d2 /= 1000.0, TimeUnit.MINUTES);
                    Duration duration2 = Duration.getInstance(d2 * 100.0 / d, TimeUnit.MINUTES);
                    Date date3 = projectCalendar.getDate(date2, duration2, false);
                    d2 = MPPUtility.getDouble(byArray, 8);
                    d2 /= 2000.0;
                    Duration duration3 = Duration.getInstance(d2 *= 6.0, TimeUnit.MINUTES);
                    TimephasedWork timephasedWork2 = new TimephasedWork();
                    timephasedWork2.setStart(date2);
                    timephasedWork2.setAmountPerDay(duration3);
                    timephasedWork2.setModified(false);
                    timephasedWork2.setFinish(date3);
                    timephasedWork2.setTotalAmount(duration);
                    if (timephasedWork2.getStart().getTime() != timephasedWork2.getFinish().getTime()) {
                        linkedList.add(timephasedWork2);
                    }
                }
            } else {
                Date date4;
                Duration duration;
                double d3;
                Date date5 = date;
                if (!list.isEmpty()) {
                    TimephasedWork timephasedWork = list.get(list.size() - 1);
                    date5 = timephasedWork.getFinish();
                }
                int n2 = 40;
                double d4 = 0.0;
                TimephasedItem timephasedItem = null;
                int n3 = 0;
                for (int i = 0; i < n && n2 + 28 <= byArray.length; ++i) {
                    d3 = MPPUtility.getInt(byArray, n2);
                    duration = Duration.getInstance(d3 /= 80.0, TimeUnit.MINUTES);
                    date4 = duration.getDuration() == 0.0 ? date5 : projectCalendar.getDate(date5, duration, true);
                    double d5 = MPPUtility.getDouble(byArray, n2 + 4);
                    double d6 = d5 - d4;
                    Duration duration4 = Duration.getInstance(d6 /= 1000.0, TimeUnit.MINUTES);
                    d4 = d5;
                    d3 = MPPUtility.getDouble(byArray, n2 + 12);
                    d3 /= 2000.0;
                    Duration duration5 = Duration.getInstance(d3 *= 6.0, TimeUnit.MINUTES);
                    int n4 = MPPUtility.getShort(byArray, n2 + 22);
                    boolean bl = i > 0 && n3 != 0 && n4 == 0 || (n4 & 0x3000) != 0;
                    n3 = n4;
                    TimephasedWork timephasedWork = new TimephasedWork();
                    timephasedWork.setStart(date4);
                    timephasedWork.setAmountPerDay(duration5);
                    timephasedWork.setModified(bl);
                    timephasedWork.setTotalAmount(duration4);
                    if (timephasedItem != null) {
                        Date date6 = projectCalendar.getDate(date5, duration, false);
                        timephasedItem.setFinish(date6);
                        if (timephasedItem.getStart().getTime() == timephasedItem.getFinish().getTime()) {
                            linkedList.removeLast();
                        }
                    }
                    linkedList.add(timephasedWork);
                    timephasedItem = timephasedWork;
                    n2 += 28;
                }
                if (timephasedItem != null) {
                    d3 = MPPUtility.getInt(byArray, 24);
                    duration = Duration.getInstance(d3 /= 80.0, TimeUnit.MINUTES);
                    date4 = projectCalendar.getDate(date5, duration, false);
                    timephasedItem.setFinish(date4);
                    if (timephasedItem.getStart().getTime() == timephasedItem.getFinish().getTime()) {
                        linkedList.removeLast();
                    }
                }
            }
        }
        return linkedList;
    }

    public boolean getWorkModified(List<TimephasedWork> list) {
        TimephasedWork timephasedWork;
        boolean bl = false;
        Iterator<TimephasedWork> iterator = list.iterator();
        while (iterator.hasNext() && !(bl = (timephasedWork = iterator.next()).getModified())) {
        }
        return bl;
    }

    public TimephasedWorkContainer getBaselineWork(ResourceAssignment resourceAssignment, ProjectCalendar projectCalendar, TimephasedWorkNormaliser timephasedWorkNormaliser, byte[] byArray, boolean bl) {
        DefaultTimephasedWorkContainer defaultTimephasedWorkContainer = null;
        if (byArray != null && byArray.length > 0) {
            LinkedList<TimephasedItem> linkedList = null;
            int n = 8;
            int n2 = 40;
            double d = 0.0;
            Date date = MPPUtility.getTimestampFromTenths(byArray, n + 36);
            n += n2;
            TimephasedItem timephasedItem = null;
            while (n + n2 <= byArray.length) {
                double d2 = (double)((long)MPPUtility.getDouble(byArray, n + 20)) / 1000.0;
                if (!Duration.durationValueEquals(d2, d)) {
                    double d3 = (double)MPPUtility.getInt(byArray, n + 8) / 10.0;
                    double d4 = (double)MPPUtility.getInt(byArray, n + 28) / 10.0;
                    double d5 = d2 - d;
                    double d6 = d5 - (d3 + d4);
                    double d7 = d6 / (d3 + d4);
                    double d8 = 480.0;
                    double d9 = d8 * d7;
                    timephasedItem = new TimephasedWork();
                    timephasedItem.setFinish(MPPUtility.getTimestampFromTenths(byArray, n + 16));
                    timephasedItem.setStart(date);
                    timephasedItem.setTotalAmount(Duration.getInstance(d5, TimeUnit.MINUTES));
                    timephasedItem.setAmountPerDay(Duration.getInstance(d8 + d9, TimeUnit.MINUTES));
                    d = d2;
                    if (linkedList == null) {
                        linkedList = new LinkedList<TimephasedItem>();
                    }
                    linkedList.add(timephasedItem);
                }
                date = MPPUtility.getTimestampFromTenths(byArray, n + 36);
                n += n2;
            }
            if (linkedList != null) {
                if (timephasedItem != null) {
                    timephasedItem.setFinish(resourceAssignment.getFinish());
                }
                defaultTimephasedWorkContainer = new DefaultTimephasedWorkContainer(projectCalendar, timephasedWorkNormaliser, linkedList, bl);
            }
        }
        return defaultTimephasedWorkContainer;
    }

    public TimephasedCostContainer getBaselineCost(ProjectCalendar projectCalendar, TimephasedCostNormaliser timephasedCostNormaliser, byte[] byArray, boolean bl) {
        DefaultTimephasedCostContainer defaultTimephasedCostContainer = null;
        if (byArray != null && byArray.length > 0) {
            LinkedList<TimephasedCost> linkedList = null;
            int n = 16;
            int n2 = 20;
            double d = 0.0;
            Date date = MPPUtility.getTimestampFromTenths(byArray, n + 16);
            n += n2;
            while (n + n2 <= byArray.length) {
                Date date2 = MPPUtility.getTimestampFromTenths(byArray, n + 16);
                double d2 = (double)((long)MPPUtility.getDouble(byArray, n + 8)) / 100.0;
                if (!this.costEquals(d, d2)) {
                    TimephasedCost timephasedCost = new TimephasedCost();
                    timephasedCost.setStart(date);
                    timephasedCost.setFinish(date2);
                    timephasedCost.setTotalAmount(d2 - d);
                    if (linkedList == null) {
                        linkedList = new LinkedList<TimephasedCost>();
                    }
                    linkedList.add(timephasedCost);
                    d = d2;
                }
                date = date2;
                n += n2;
            }
            if (linkedList != null) {
                defaultTimephasedCostContainer = new DefaultTimephasedCostContainer(projectCalendar, timephasedCostNormaliser, linkedList, bl);
            }
        }
        return defaultTimephasedCostContainer;
    }

    private boolean costEquals(double d, double d2) {
        return NumberHelper.equals(d, d2, 1.0E-5);
    }
}

