/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (0ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(167ul, 66ul, 187ul)
 * (3ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333333333262ul, 88ul, 97ul)
 * (3ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(170ul, 69ul, 190ul)
 * (1192ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333333334451ul, 1277ul, 1286ul)
 * (1192ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(1359ul, 1258ul, 1379ul)
 * (1048576ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333334381835ul, 1048661ul, 1048670ul)
 * (1048576ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(1048743ul, 1048642ul, 1048763ul)
 * (4251475ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333337584734ul, 4251560ul, 4251569ul)
 * (4251475ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(4251642ul, 4251541ul, 4251662ul)
 * (29852643761ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333363185977020ul, 29852643846ul, 29852643855ul)
 * (29852643761ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(29852643928ul, 29852643827ul, 29852643948ul)
 * (4398046511104ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333337731379844363ul, 4398046511189ul, 4398046511198ul)
 * (4398046511104ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(4398046511271ul, 4398046511170ul, 4398046511291ul)
 * (3948976685146ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333337282310018405ul, 3948976685231ul, 3948976685240ul)
 * (3948976685146ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(3948976685313ul, 3948976685212ul, 3948976685333ul)
 * (135763469567146206ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1469096802900479465ul, 135763469567146291ul, 135763469567146300ul)
 * (135763469567146206ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(135763469567146373ul, 135763469567146272ul, 135763469567146393ul)
 * (11654173250180970009ul + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(12987506583514303268ul, 11654173250180970094ul, 11654173250180970103ul)
 * (11654173250180970009ul + u64vec3(167ul, 66ul, 187ul)) => u64vec3(11654173250180970176ul, 11654173250180970075ul, 11654173250180970196ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((0ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array1;
  float[all(equal((3ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333333333262ul, 88ul, 97ul))) ? 1 : -1] array2;
  float[all(equal((3ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(170ul, 69ul, 190ul))) ? 1 : -1] array3;
  float[all(equal((1192ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333333334451ul, 1277ul, 1286ul))) ? 1 : -1] array4;
  float[all(equal((1192ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(1359ul, 1258ul, 1379ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333334381835ul, 1048661ul, 1048670ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(1048743ul, 1048642ul, 1048763ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333337584734ul, 4251560ul, 4251569ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(4251642ul, 4251541ul, 4251662ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333363185977020ul, 29852643846ul, 29852643855ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(29852643928ul, 29852643827ul, 29852643948ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333337731379844363ul, 4398046511189ul, 4398046511198ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(4398046511271ul, 4398046511170ul, 4398046511291ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333337282310018405ul, 3948976685231ul, 3948976685240ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(3948976685313ul, 3948976685212ul, 3948976685333ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1469096802900479465ul, 135763469567146291ul, 135763469567146300ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(135763469567146373ul, 135763469567146272ul, 135763469567146393ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(12987506583514303268ul, 11654173250180970094ul, 11654173250180970103ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul + u64vec3(167ul, 66ul, 187ul)), u64vec3(11654173250180970176ul, 11654173250180970075ul, 11654173250180970196ul))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
