/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.info;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.info.WebContextInfo;
import org.osgi.framework.Bundle;

public class WebApplicationInfo
implements Comparable<WebApplicationInfo> {
    private String contextPath;
    private Bundle bundle;
    private boolean wab;
    private boolean whiteboard;
    private boolean httpService;
    private String deploymentState;
    private final List<String> servletContainerInitializers = new ArrayList<String>();
    private final List<URL> metaInfResources = new ArrayList<URL>();
    private final List<URL> descriptors = new ArrayList<URL>();
    private final List<URL> wabClassPath = new ArrayList<URL>();
    private final Set<URL> wabClassPathSkipped = new HashSet<URL>();
    private final List<Bundle> containerFragmentBundles = new ArrayList<Bundle>();
    private final List<Bundle> applicationFragmentBundles = new ArrayList<Bundle>();
    private boolean replaced;
    private WebContextInfo contextModel;

    public WebApplicationInfo() {
    }

    public WebApplicationInfo(OsgiContextModel ocm) {
        if (ocm != null) {
            this.contextModel = new WebContextInfo(ocm);
            this.contextPath = ocm.getContextPath();
            this.bundle = ocm.getOwnerBundle();
            this.wab = ocm.isWab();
            this.whiteboard = ocm.isWhiteboard();
            this.httpService = !this.wab && !this.whiteboard;
        }
    }

    public WebApplicationInfo(OsgiContextModel ocm, boolean replaced) {
        this(ocm);
        if (replaced) {
            this.replaced = replaced;
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public boolean isWab() {
        return this.wab;
    }

    public void setWab(boolean wab) {
        this.wab = wab;
    }

    public boolean isWhiteboard() {
        return this.whiteboard;
    }

    public boolean isHttpService() {
        return this.httpService;
    }

    public String getDeploymentState() {
        return this.deploymentState;
    }

    public void setDeploymentState(String deploymentState) {
        this.deploymentState = deploymentState;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public List<String> getServletContainerInitializers() {
        return this.servletContainerInitializers;
    }

    public List<URL> getMetaInfResources() {
        return this.metaInfResources;
    }

    public List<URL> getDescriptors() {
        return this.descriptors;
    }

    public List<URL> getWabClassPath() {
        return this.wabClassPath;
    }

    public Set<URL> getWabClassPathSkipped() {
        return this.wabClassPathSkipped;
    }

    public List<Bundle> getContainerFragmentBundles() {
        return this.containerFragmentBundles;
    }

    public List<Bundle> getApplicationFragmentBundles() {
        return this.applicationFragmentBundles;
    }

    public void setContextModel(WebContextInfo contextModel) {
        this.contextModel = contextModel;
    }

    public int getServiceRank() {
        return this.contextModel == null ? 0 : this.contextModel.getModel().getServiceRank();
    }

    public long getServiceId() {
        return this.contextModel == null ? 0L : this.contextModel.getModel().getServiceId();
    }

    public String getName() {
        return this.contextModel == null ? "-" : this.contextModel.getModel().getName();
    }

    public String getScope() {
        if (this.contextModel == null) {
            return "?";
        }
        OsgiContextModel ocm = this.contextModel.getModel();
        if (ocm.getContextReference() == null) {
            return "static*";
        }
        return (String)ocm.getContextReference().getProperty("service.scope");
    }

    public List<String> getContextRegistrationIdProperties() {
        if (this.contextModel == null) {
            return Collections.emptyList();
        }
        TreeSet props = new TreeSet();
        this.contextModel.getModel().getContextRegistrationProperties().forEach((k, v) -> {
            if ("httpContext.id".equals(k) || "httpContext.path".equals(k) || "osgi.http.whiteboard.context.httpservice".equals(k) || "osgi.http.whiteboard.context.name".equals(k) || "osgi.http.whiteboard.context.path".equals(k)) {
                props.add(String.format("%s=%s", k, v));
            }
        });
        return new ArrayList<String>(props);
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    @Override
    public int compareTo(WebApplicationInfo other) {
        if (!this.contextPath.equals(other.contextPath)) {
            int s2;
            int s1 = this.contextPath.split("/").length;
            if (s1 == (s2 = other.contextPath.split("/").length)) {
                return this.contextPath.compareTo(other.contextPath);
            }
            return s1 < s2 ? -1 : 1;
        }
        if (this.contextModel != null && other.contextModel != null) {
            return this.contextModel.getModel().compareTo(other.contextModel.getModel());
        }
        return this.bundle.compareTo((Object)other.bundle);
    }
}

