/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.mbeans;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.mbeans.ManagementMBean;

public class Management
implements ManagementMBean {
    private ManagementMBean getManagementService() {
        return (ManagementMBean)Management.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService");
    }

    @Override
    public void startManagement() {
        ManagementMBean mgmtService = this.getManagementService();
        if (mgmtService != null) {
            mgmtService.startManagement();
        }
    }

    @Override
    public void stopManagement() {
        ManagementMBean mgmtService = this.getManagementService();
        if (mgmtService != null) {
            mgmtService.stopManagement();
        }
    }

    @Override
    public boolean isManagementActive() {
        ManagementMBean mgmtService = this.getManagementService();
        if (mgmtService == null) {
            return false;
        }
        return mgmtService.isManagementActive();
    }

    @Override
    public String getSystemIdentifier() {
        ManagementMBean mgmtService = this.getManagementService();
        if (mgmtService == null) {
            return null;
        }
        return mgmtService.getSystemIdentifier();
    }

    private static Object getSystemModule(final String factoryInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getSystemModule(factoryInterface);
            }
        });
    }
}

