/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class HeapRowLocation
extends DataType
implements RowLocation,
RefDataValue {
    private long pageno;
    private int recid;
    private RecordHandle rh;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(HeapRowLocation.class);
    private static final int RECORD_HANDLE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(RecordId.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.rh) {
            sz += RECORD_HANDLE_MEMORY_USAGE;
        }
        return sz;
    }

    @Override
    public String getTypeName() {
        return "RowLocation";
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new HeapRowLocation();
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new HeapRowLocation(this);
    }

    @Override
    public DataValueDescriptor recycle() {
        this.pageno = 0L;
        this.recid = 0;
        this.rh = null;
        return this;
    }

    @Override
    public int getLength() {
        return 10;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) {
        int result = this.compare(other);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Unexpected operation");
        return false;
    }

    @Override
    public int compare(DataValueDescriptor other) {
        SanityManager.ASSERT((boolean)(other instanceof HeapRowLocation));
        HeapRowLocation arg = (HeapRowLocation)other;
        long myPage = this.pageno;
        long otherPage = arg.pageno;
        if (myPage < otherPage) {
            return -1;
        }
        if (myPage > otherPage) {
            return 1;
        }
        int myRecordId = this.recid;
        int otherRecordId = arg.recid;
        if (myRecordId == otherRecordId) {
            return 0;
        }
        if (myRecordId < otherRecordId) {
            return -1;
        }
        return 1;
    }

    @Override
    public void setValue(RowLocation rowLocation) {
        HeapRowLocation hrl = (HeapRowLocation)rowLocation;
        this.setFrom(hrl.rh);
    }

    HeapRowLocation(RecordHandle rh) {
        this.setFrom(rh);
    }

    public HeapRowLocation() {
        this.pageno = 0L;
        this.recid = 0;
    }

    private HeapRowLocation(HeapRowLocation other) {
        this.pageno = other.pageno;
        this.recid = other.recid;
        this.rh = other.rh;
    }

    public RecordHandle getRecordHandle(ContainerHandle ch) throws StandardException {
        if (this.rh != null) {
            return this.rh;
        }
        this.rh = ch.makeRecordHandle(this.pageno, this.recid);
        return this.rh;
    }

    void setFrom(RecordHandle rh) {
        this.pageno = rh.getPageNumber();
        this.recid = rh.getId();
        this.rh = rh;
    }

    @Override
    public int getTypeFormatId() {
        return 90;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.pageno);
        CompressedNumber.writeInt(out, this.recid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pageno = CompressedNumber.readLong(in);
        this.recid = CompressedNumber.readInt(in);
        this.rh = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.pageno = in.readCompressedLong();
        this.recid = in.readCompressedInt();
        this.rh = null;
    }

    @Override
    public void restoreToNull() {
        SanityManager.THROWASSERT((String)"HeapRowLocation is never null");
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) {
        SanityManager.ASSERT((boolean)(theValue instanceof HeapRowLocation), (String)"Should only be set from another HeapRowLocation");
        HeapRowLocation that = (HeapRowLocation)theValue;
        this.pageno = that.pageno;
        this.recid = that.recid;
        this.rh = that.rh;
    }

    @Override
    public boolean equals(Object ref) {
        if (ref instanceof HeapRowLocation) {
            HeapRowLocation other = (HeapRowLocation)ref;
            return this.pageno == other.pageno && this.recid == other.recid;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.pageno ^ this.recid;
    }

    public String toString() {
        String string = "(" + this.pageno + "," + this.recid + ")";
        return string;
    }
}

