/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SumAggregator;
import org.apache.derby.shared.common.error.StandardException;

public final class AvgAggregator
extends SumAggregator {
    private long count;
    private int scale;

    @Override
    protected void accumulate(DataValueDescriptor addend) throws StandardException {
        if (this.count == 0L) {
            String typeName = addend.getTypeName();
            if (typeName.equals("TINYINT") || typeName.equals("SMALLINT") || typeName.equals("INTEGER") || typeName.equals("BIGINT")) {
                this.scale = 0;
            } else if (typeName.equals("REAL") || typeName.equals("DOUBLE")) {
                this.scale = 31;
            } else {
                this.scale = ((SQLDecimal)addend).getDecimalValueScale();
                if (this.scale < 4) {
                    this.scale = 4;
                }
            }
        }
        try {
            super.accumulate(addend);
            ++this.count;
            return;
        }
        catch (StandardException se) {
            if (!se.getMessageId().equals("22003")) {
                throw se;
            }
            String typeName = this.value.getTypeName();
            NumberDataType newValue = typeName.equals("INTEGER") ? new SQLLongint() : (typeName.equals("TINYINT") || typeName.equals("SMALLINT") ? new SQLInteger() : (typeName.equals("REAL") ? new SQLDouble() : new SQLDecimal()));
            newValue.setValue(this.value);
            this.value = newValue;
            this.accumulate(addend);
            return;
        }
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        AvgAggregator otherAvg = (AvgAggregator)addend;
        if (this.count == 0L) {
            this.count = otherAvg.count;
            this.value = otherAvg.value;
            this.scale = otherAvg.scale;
            return;
        }
        if (otherAvg.value != null) {
            this.count += otherAvg.count - 1L;
            this.accumulate(otherAvg.value);
        }
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        String typeName;
        if (this.count == 0L) {
            return null;
        }
        NumberDataValue sum = (NumberDataValue)this.value;
        NumberDataValue avg = (NumberDataValue)this.value.getNewNull();
        if (this.count > Integer.MAX_VALUE && ((typeName = sum.getTypeName()).equals("INTEGER") || typeName.equals("TINYINT") || typeName.equals("SMALLINT"))) {
            avg.setValue(0);
            return avg;
        }
        SQLLongint countv = new SQLLongint(this.count);
        sum.divide(sum, countv, avg, this.scale);
        return avg;
    }

    @Override
    public ExecAggregator newAggregator() {
        return new AvgAggregator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.count);
        out.writeInt(this.scale);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.count = in.readLong();
        this.scale = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 149;
    }
}

