/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class SYSCOLPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLPERMS";
    private static final int COLPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int TABLEID_COL_NUM = 4;
    private static final int TYPE_COL_NUM = 5;
    protected static final int COLUMNS_COL_NUM = 6;
    private static final int COLUMN_COUNT = 6;
    static final int GRANTEE_TABLE_TYPE_GRANTOR_INDEX_NUM = 0;
    static final int COLPERMSID_INDEX_NUM = 1;
    static final int TABLEID_INDEX_NUM = 2;
    protected static final int TOTAL_NUM_OF_INDEXES = 3;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 5, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_TABLE_TYPE_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"286cc01e-0103-0e39-b8e7-00000010f010", "6074401f-0103-0e39-b8e7-00000010f010", "787c0020-0103-0e39-b8e7-00000010f010", "c9a3808d-010c-42a2-ae15-0000000f67f8", "80220011-010c-bc85-060d-000000109ab8"};

    SYSCOLPERMSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(6, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String colPermID = null;
        DataValueDescriptor grantee = null;
        DataValueDescriptor grantor = null;
        String tableID = null;
        String type = null;
        FormatableBitSet columns = null;
        if (td == null) {
            grantee = this.getNullAuthorizationID();
            grantor = this.getNullAuthorizationID();
        } else {
            ColPermsDescriptor cpd = (ColPermsDescriptor)td;
            UUID oid = cpd.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                cpd.setUUID(oid);
            }
            colPermID = oid.toString();
            grantee = this.getAuthorizationID(cpd.getGrantee());
            grantor = this.getAuthorizationID(cpd.getGrantor());
            tableID = cpd.getTableUUID().toString();
            type = cpd.getType();
            columns = cpd.getColumns();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(6);
        row.setColumn(1, new SQLChar(colPermID));
        row.setColumn(2, grantee);
        row.setColumn(3, grantor);
        row.setColumn(4, new SQLChar(tableID));
        row.setColumn(5, new SQLChar(type));
        row.setColumn(6, new UserType(columns));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTuple, DataDictionary dataDictionary) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 6 ? 1 : 0) != 0, (String)"Wrong size row passed to SYSCOLPERMSRowFactory.buildDescriptor");
        String colPermsUUIDString = row.getColumn(1).getString();
        UUID colPermsUUID = this.getUUIDFactory().recreateUUID(colPermsUUIDString);
        String tableUUIDString = row.getColumn(4).getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        String type = row.getColumn(5).getString();
        FormatableBitSet columns = (FormatableBitSet)row.getColumn(6).getObject();
        SanityManager.ASSERT(("s".equals(type) || "S".equals(type) || "u".equals(type) || "U".equals(type) || "r".equals(type) || "R".equals(type) ? 1 : 0) != 0, (String)"Invalid type passed to SYSCOLPERMSRowFactory.buildDescriptor");
        ColPermsDescriptor colPermsDesc = new ColPermsDescriptor(dataDictionary, this.getAuthorizationID(row, 2), this.getAuthorizationID(row, 3), tableUUID, type, columns);
        colPermsDesc.setUUID(colPermsUUID);
        return colPermsDesc;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("COLPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getJavaColumn("COLUMNS", "org.apache.derby.iapi.services.io.FormatableBitSet", false)};
    }

    @Override
    public ExecIndexRow buildIndexKeyRow(int indexNumber, PermissionsDescriptor perm) throws StandardException {
        ExecIndexRow row = null;
        switch (indexNumber) {
            case 0: {
                row = this.getExecutionFactory().getIndexableRow(3);
                row.setColumn(1, this.getAuthorizationID(perm.getGrantee()));
                ColPermsDescriptor colPerms = (ColPermsDescriptor)perm;
                String tableUUIDStr = colPerms.getTableUUID().toString();
                row.setColumn(2, new SQLChar(tableUUIDStr));
                row.setColumn(3, new SQLChar(colPerms.getType()));
                break;
            }
            case 1: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String colPermsUUIDStr = perm.getObjectID().toString();
                row.setColumn(1, new SQLChar(colPermsUUIDStr));
                break;
            }
            case 2: {
                row = this.getExecutionFactory().getIndexableRow(1);
                ColPermsDescriptor colPerms = (ColPermsDescriptor)perm;
                String tableUUIDStr = colPerms.getTableUUID().toString();
                row.setColumn(1, new SQLChar(tableUUIDStr));
            }
        }
        return row;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    @Override
    public int orPermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        ColPermsDescriptor colPerms = (ColPermsDescriptor)perm;
        FormatableBitSet existingColSet = (FormatableBitSet)row.getColumn(6).getObject();
        FormatableBitSet newColSet = colPerms.getColumns();
        boolean changed = false;
        int i = newColSet.anySetBit();
        while (i >= 0) {
            if (!existingColSet.get(i)) {
                existingColSet.set(i);
                changed = true;
            }
            i = newColSet.anySetBit(i);
        }
        if (changed) {
            colsChanged[5] = true;
            return 1;
        }
        return 0;
    }

    @Override
    public int removePermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        ColPermsDescriptor colPerms = (ColPermsDescriptor)perm;
        FormatableBitSet removeColSet = colPerms.getColumns();
        if (removeColSet == null) {
            return -1;
        }
        FormatableBitSet existingColSet = (FormatableBitSet)row.getColumn(6).getObject();
        boolean changed = false;
        int i = removeColSet.anySetBit();
        while (i >= 0) {
            if (existingColSet.get(i)) {
                existingColSet.clear(i);
                changed = true;
            }
            i = removeColSet.anySetBit(i);
        }
        if (changed) {
            colsChanged[5] = true;
            if (existingColSet.anySetBit() < 0) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void setUUIDOfThePassedDescriptor(ExecRow row, PermissionsDescriptor perm) throws StandardException {
        DataValueDescriptor existingPermDVD = row.getColumn(1);
        perm.setUUID(this.getUUIDFactory().recreateUUID(existingPermDVD.getString()));
    }
}

