/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.JRubyClassLoader;

public class ClassDefiningJRubyClassLoader
extends URLClassLoader
implements ClassDefiningClassLoader {
    public static final ProtectionDomain DEFAULT_DOMAIN;
    private final Set<String> definedClasses = new ConcurrentSkipListSet<String>();

    public ClassDefiningJRubyClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public Class<?> defineClass(String name2, byte[] bytes2) {
        Class<?> aClass = super.defineClass(name2, bytes2, 0, bytes2.length, DEFAULT_DOMAIN);
        this.definedClasses.add(name2);
        return aClass;
    }

    public Class<?> defineClass(String name2, byte[] bytes2, ProtectionDomain domain) {
        Class<?> aClass = super.defineClass(name2, bytes2, 0, bytes2.length, domain);
        this.definedClasses.add(name2);
        return aClass;
    }

    public boolean hasClass(String name2) {
        return this.hasDefinedClass(name2) || super.findResource(name2.replace('.', '/') + ".class") != null;
    }

    @Override
    public boolean hasDefinedClass(String name2) {
        return this.definedClasses.contains(name2);
    }

    static {
        ProtectionDomain defaultDomain = null;
        try {
            defaultDomain = JRubyClassLoader.class.getProtectionDomain();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEFAULT_DOMAIN = defaultDomain;
    }
}

