/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DateUtil {
    private static final Date ISO8001_TIME = new GregorianCalendar().getTime();

    private DateUtil() {
    }

    public static Date normalizeDate(Date fromDate, Type toType) {
        return DateUtil.normalizeDate(fromDate, toType, true);
    }

    public static Date normalizeDate(Date fromDate, Type toType, boolean convertSerial) {
        if (fromDate == null) {
            throw new IllegalArgumentException();
        }
        if (toType == null) {
            throw new IllegalArgumentException();
        }
        if (convertSerial) {
            BigDecimal serial = HSSFDateUtil.getExcelDate(fromDate);
            serial = DateUtil.normalizeDate(serial, toType);
            fromDate = HSSFDateUtil.getJavaDate(serial);
        }
        if (toType.isFlagSet("type.time")) {
            return new Time(fromDate.getTime());
        }
        if (toType.isFlagSet("type.date")) {
            return new java.sql.Date(fromDate.getTime());
        }
        if (toType.isFlagSet("type.datetime")) {
            return new Date(fromDate.getTime());
        }
        return fromDate;
    }

    public static BigDecimal normalizeDate(BigDecimal fromSerialDate, Type toType) {
        if (fromSerialDate == null) {
            throw new IllegalArgumentException();
        }
        if (toType == null) {
            throw new IllegalArgumentException();
        }
        if (toType.isFlagSet("type.time")) {
            BigDecimal o = fromSerialDate.setScale(40, 0);
            return o.subtract(new BigDecimal(o.intValue()));
        }
        if (toType.isFlagSet("type.date")) {
            return NumberUtil.performIntRounding(fromSerialDate);
        }
        return fromSerialDate;
    }

    public static Date now(LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(14, 0);
        return gc.getTime();
    }

    public static Date createDateTime(int year, int month, int day, int hour, int minute, int second, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(5, day);
        gc.set(2, month);
        gc.set(1, year);
        gc.set(14, 0);
        gc.set(11, hour);
        gc.set(12, minute);
        gc.set(13, second);
        return gc.getTime();
    }

    public static Time createTime(int hour, int minute, int second, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.setTime(ISO8001_TIME);
        gc.set(14, 0);
        gc.set(11, hour);
        gc.set(12, minute);
        gc.set(13, second);
        return new Time(gc.getTime().getTime());
    }

    public static java.sql.Date createDate(int year, int month, int day, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(5, day);
        gc.set(2, month - 1);
        gc.set(1, year);
        gc.set(14, 0);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        return new java.sql.Date(gc.getTime().getTime());
    }

    public static Calendar createCalendar(Date date, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.setTime(date);
        return gc;
    }
}

