/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.StyleSheetUtility;
import org.jfree.report.EmptyReportDataFactory;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.structure.ReportDefinition;
import org.jfree.report.util.ReportParameters;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class JFreeReport
extends ReportDefinition
implements ReportStructureRoot {
    private ModifiableConfiguration reportConfiguration;
    private ArrayList styleSheets;
    private StyleSheet pageFormatStyleSheet;
    private CSSPageRule pageRule;
    private ReportParameters parameters;
    private ReportDataFactory dataFactory;
    private ResourceManager resourceManager;
    private ResourceKey baseResource;

    public JFreeReport() {
        this.setType("report");
        this.reportConfiguration = new HierarchicalConfiguration(JFreeReportBoot.getInstance().getGlobalConfig());
        this.styleSheets = new ArrayList();
        this.parameters = new ReportParameters();
        this.dataFactory = new EmptyReportDataFactory();
        this.pageFormatStyleSheet = new StyleSheet();
        this.pageRule = new CSSPageRule(this.pageFormatStyleSheet, null, null, null);
        this.pageFormatStyleSheet.addRule((StyleRule)this.pageRule);
        this.setQuery("default");
    }

    @Override
    public Configuration getConfiguration() {
        return this.reportConfiguration;
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        this.styleSheets.add(styleSheet);
    }

    public void removeStyleSheet(StyleSheet styleSheet) {
        this.styleSheets.remove(styleSheet);
    }

    public StyleSheet getStyleSheet(int n) {
        if (n == 0) {
            return this.pageFormatStyleSheet;
        }
        return (StyleSheet)this.styleSheets.get(n - 1);
    }

    public int getStyleSheetCount() {
        return this.styleSheets.size() + 1;
    }

    @Override
    public JFreeReport getRootReport() {
        return this;
    }

    @Override
    public ReportParameters getInputParameters() {
        return this.parameters;
    }

    @Override
    public ReportDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(ReportDataFactory reportDataFactory) {
        if (reportDataFactory == null) {
            throw new NullPointerException();
        }
        this.dataFactory = reportDataFactory;
    }

    @Override
    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public ResourceKey getBaseResource() {
        return this.baseResource;
    }

    public void setBaseResource(ResourceKey resourceKey) {
        this.baseResource = resourceKey;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageRule.clear();
        StyleSheetUtility.updateRuleForPage((CSSPageRule)this.pageRule, (PageFormat)pageFormat);
    }

    public PageFormat getPageFormat() {
        return StyleSheetUtility.getPageFormat((CSSPageRule)this.pageRule);
    }

    public ModifiableConfiguration getEditableConfiguration() {
        return this.reportConfiguration;
    }

    @Override
    public Locale getLocale() {
        Locale locale = super.getLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JFreeReport jFreeReport = (JFreeReport)super.clone();
        jFreeReport.dataFactory = this.dataFactory.derive();
        jFreeReport.parameters = (ReportParameters)this.parameters.clone();
        jFreeReport.pageRule = (CSSPageRule)this.pageRule.clone();
        jFreeReport.styleSheets = (ArrayList)this.styleSheets.clone();
        jFreeReport.pageFormatStyleSheet = this.pageFormatStyleSheet;
        return jFreeReport;
    }
}

