/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonArrayAggFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonArrayAggFunction
extends JsonArrayAggFunction {
    private final boolean supportsStandard;

    public PostgreSQLJsonArrayAggFunction(boolean supportsStandard, TypeConfiguration typeConfiguration) {
        super(true, typeConfiguration);
        this.supportsStandard = supportsStandard;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        if (this.supportsStandard) {
            super.render(sqlAppender, sqlAstArguments, filter, withinGroup, returnType, translator);
        } else {
            Expression arg;
            String jsonTypeName = translator.getSessionFactory().getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, translator.getSessionFactory().getJdbcServices().getDialect());
            sqlAppender.appendSql(jsonTypeName);
            sqlAppender.appendSql("_agg");
            JsonNullBehavior nullBehavior = sqlAstArguments.size() > 1 ? (JsonNullBehavior)sqlAstArguments.get(1) : JsonNullBehavior.ABSENT;
            sqlAppender.appendSql('(');
            SqlAstNode firstArg = sqlAstArguments.get(0);
            if (firstArg instanceof Distinct) {
                Distinct distinct = (Distinct)firstArg;
                sqlAppender.appendSql("distinct ");
                arg = distinct.getExpression();
            } else {
                arg = (Expression)firstArg;
            }
            this.renderArgument(sqlAppender, arg, nullBehavior, translator);
            if (withinGroup != null && !withinGroup.isEmpty()) {
                translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
                sqlAppender.appendSql(" order by ");
                withinGroup.get(0).accept(translator);
                for (int i = 1; i < withinGroup.size(); ++i) {
                    sqlAppender.appendSql(',');
                    withinGroup.get(i).accept(translator);
                }
                translator.getCurrentClauseStack().pop();
            }
            sqlAppender.appendSql(')');
            if (filter != null) {
                translator.getCurrentClauseStack().push(Clause.WHERE);
                sqlAppender.appendSql(" filter (where ");
                filter.accept(translator);
                if (nullBehavior != JsonNullBehavior.NULL) {
                    sqlAppender.appendSql(" and ");
                    arg.accept(translator);
                    sqlAppender.appendSql(" is not null");
                }
                sqlAppender.appendSql(')');
                translator.getCurrentClauseStack().pop();
            } else if (nullBehavior != JsonNullBehavior.NULL) {
                sqlAppender.appendSql(" filter (where ");
                arg.accept(translator);
                sqlAppender.appendSql(" is not null)");
            }
        }
    }
}

