/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.sqm.CastType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.MappingContext;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.TrueFalseConverter;
import org.hibernate.type.YesNoConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ConvertedBasicTypeImpl<J>
implements ConvertedBasicType<J>,
AdjustableBasicType<J>,
ProcedureParameterExtractionAware<J>,
ProcedureParameterNamedBinder<J> {
    public static final String EXTERNALIZED_PREFIX = "convertedBasicType";
    public static final String[] NO_REG_KEYS = ArrayHelper.EMPTY_STRING_ARRAY;
    private static int count;
    private final String name;
    private final String description;
    private final BasicValueConverter<J, ?> converter;
    private final JdbcType jdbcType;
    private final int[] sqlTypes;
    private final ValueBinder<J> jdbcValueBinder;
    private final ValueExtractor<J> jdbcValueExtractor;
    private final JdbcLiteralFormatter<J> jdbcLiteralFormatter;

    public ConvertedBasicTypeImpl(String name, JdbcType jdbcType, BasicValueConverter<J, ?> converter) {
        this(name, String.format(Locale.ROOT, "%s@%s(%s,%s)", EXTERNALIZED_PREFIX, ++count, converter.getDomainJavaType().getJavaTypeClass().getName(), jdbcType.getDefaultSqlTypeCode()), jdbcType, converter);
    }

    public ConvertedBasicTypeImpl(String name, String description, JdbcType jdbcType, BasicValueConverter<J, ?> converter) {
        this.name = name;
        this.description = description;
        this.converter = converter;
        this.jdbcType = jdbcType;
        this.sqlTypes = new int[]{jdbcType.getDdlTypeCode()};
        this.jdbcValueBinder = jdbcType.getBinder(converter.getRelationalJavaType());
        this.jdbcValueExtractor = jdbcType.getExtractor(converter.getRelationalJavaType());
        this.jdbcLiteralFormatter = jdbcType.getJdbcLiteralFormatter(converter.getRelationalJavaType());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRegistrationKeys() {
        return NO_REG_KEYS;
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.converter;
    }

    @Override
    public ValueExtractor<J> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<J> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public JdbcLiteralFormatter getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    @Override
    public Class<J> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.converter.getRelationalJavaType();
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public final JavaType<J> getJavaTypeDescriptor() {
        return this.converter.getDomainJavaType();
    }

    @Override
    public final JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public final Class<?> getReturnedClass() {
        return this.converter.getDomainJavaType().getJavaTypeClass();
    }

    @Override
    public final int getColumnSpan(MappingContext mapping) throws MappingException {
        return 1;
    }

    @Override
    public final int[] getSqlTypeCodes(MappingContext mappingContext) throws MappingException {
        return this.sqlTypes;
    }

    @Override
    public final boolean isAssociationType() {
        return false;
    }

    @Override
    public final boolean isCollectionType() {
        return false;
    }

    @Override
    public final boolean isComponentType() {
        return false;
    }

    @Override
    public final boolean isEntityType() {
        return false;
    }

    @Override
    public final boolean isAnyType() {
        return false;
    }

    @Override
    public final boolean isSame(Object x, Object y) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.isEqual(x, y);
    }

    @Override
    public boolean isEqual(Object one, Object another) {
        return this.converter.getDomainJavaType().areEqual(one, another);
    }

    @Override
    public int getHashCode(Object x) {
        return this.converter.getDomainJavaType().extractHashCode(x);
    }

    @Override
    public final int getHashCode(Object x, SessionFactoryImplementor factory) {
        return this.getHashCode(x);
    }

    @Override
    public final int compare(Object x, Object y) {
        return this.converter.getDomainJavaType().getComparator().compare(x, y);
    }

    @Override
    public final boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) {
        return this.isDirty(old, current);
    }

    @Override
    public final boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) {
        return checkable[0] && this.isDirty(old, current);
    }

    protected final boolean isDirty(Object old, Object current) {
        return !this.isSame(old, current);
    }

    @Override
    public final boolean isModified(Object oldHydratedState, Object currentState, boolean[] checkable, SharedSessionContractImplementor session) {
        return this.isDirty(oldHydratedState, currentState);
    }

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (settable[0]) {
            this.nullSafeSet(st, value, index, session);
        }
    }

    @Override
    public void nullSafeSet(CallableStatement st, J value, String name, SharedSessionContractImplementor session) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.getJdbcValueBinder().bind(st, converted, name, (WrapperOptions)session);
    }

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.getJdbcValueBinder().bind(st, converted, index, (WrapperOptions)session);
    }

    @Override
    public final String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY || !Hibernate.isInitialized(value)) {
            return "<uninitialized>";
        }
        return this.converter.getDomainJavaType().extractLoggableRepresentation(value);
    }

    protected MutabilityPlan<J> getMutabilityPlan() {
        return this.converter.getDomainJavaType().getMutabilityPlan();
    }

    @Override
    public final boolean isMutable() {
        return this.getMutabilityPlan().isMutable();
    }

    @Override
    public final Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return this.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public final void beforeAssemble(Serializable cached, SharedSessionContractImplementor session) {
    }

    @Override
    public final Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().assemble(cached, session);
    }

    @Override
    public final Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().disassemble(value, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.converter.toRelationalValue(value);
    }

    @Override
    public final Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        return original == null && target == null ? null : this.converter.getDomainJavaType().getReplacement(original, target, session);
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        return ForeignKeyDirection.FROM_PARENT == foreignKeyDirection ? this.converter.getDomainJavaType().getReplacement(original, target, session) : target;
    }

    @Override
    public boolean canDoExtraction() {
        return true;
    }

    @Override
    public J extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        return (J)this.getValueConverter().toDomainValue(this.getJdbcValueExtractor().extract(statement, startIndex, (WrapperOptions)session));
    }

    @Override
    public J extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        return (J)this.getValueConverter().toDomainValue(this.getJdbcValueExtractor().extract(statement, paramName, (WrapperOptions)session));
    }

    @Override
    public boolean canDoSetting() {
        return true;
    }

    @Override
    public CastType getCastType() {
        JdbcType jdbcType = this.getJdbcType();
        int jdbcTypeCode = jdbcType.getDefaultSqlTypeCode();
        switch (jdbcTypeCode) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                if (this.getJavaType() != Boolean.class) break;
                return CastType.INTEGER_BOOLEAN;
            }
            case -15: 
            case 1: {
                if (this.getJavaType() != Boolean.class) break;
                if (this.converter.getRelationalJavaType().getJavaType() == Character.class) {
                    if (this.converter instanceof TrueFalseConverter) {
                        return CastType.TF_BOOLEAN;
                    }
                    if (this.converter instanceof YesNoConverter) {
                        return CastType.YN_BOOLEAN;
                    }
                }
                return CastType.YN_BOOLEAN;
            }
            case 2014: {
                if (this.getJavaType() != ZonedDateTime.class) break;
                return CastType.ZONE_TIMESTAMP;
            }
        }
        return jdbcType.getCastType();
    }

    public String toString() {
        return this.description;
    }
}

