/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import json.ext.ByteListDirectOutputStream;
import json.ext.GeneratorState;
import json.ext.RuntimeInfo;
import json.ext.StringEncoder;
import json.ext.Utils;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;

public final class Generator {
    private static final int IO_BUFFER_SIZE = 8192;
    static final Handler<RubyBignum> BIGNUM_HANDLER = new Handler<RubyBignum>(){

        @Override
        void generate(ThreadContext threadContext, Session session, RubyBignum rubyBignum, OutputStream outputStream) throws IOException {
            BigInteger bigInteger = rubyBignum.getValue();
            outputStream.write(bigInteger.toString().getBytes(StandardCharsets.UTF_8));
        }
    };
    static final Handler<RubyFixnum> FIXNUM_HANDLER = new Handler<RubyFixnum>(){

        @Override
        void generate(ThreadContext threadContext, Session session, RubyFixnum rubyFixnum, OutputStream outputStream) throws IOException {
            outputStream.write(ConvertBytes.longToCharBytes((long)rubyFixnum.getLongValue()));
        }
    };
    static final Handler<RubyFloat> FLOAT_HANDLER = new Handler<RubyFloat>(){

        @Override
        void generate(ThreadContext threadContext, Session session, RubyFloat rubyFloat, OutputStream outputStream) throws IOException {
            double d = rubyFloat.getValue();
            if ((Double.isInfinite(d) || Double.isNaN(d)) && !session.getState(threadContext).allowNaN()) {
                throw Utils.buildGeneratorError(threadContext, (IRubyObject)rubyFloat, rubyFloat + " not allowed in JSON").toThrowable();
            }
            outputStream.write(Double.toString(d).getBytes(StandardCharsets.UTF_8));
        }
    };
    private static final byte[] EMPTY_ARRAY_BYTES = "[]".getBytes();
    static final Handler<RubyArray<IRubyObject>> ARRAY_HANDLER = new Handler<RubyArray<IRubyObject>>(){

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyArray<IRubyObject> rubyArray) {
            GeneratorState generatorState = session.getState(threadContext);
            int n = generatorState.getDepth();
            int n2 = 4 + (n + 1) * generatorState.getIndent().length() + 1 + generatorState.getArrayNl().length();
            return 2 + rubyArray.size() * n2;
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyArray<IRubyObject> rubyArray, OutputStream outputStream) throws IOException {
            GeneratorState generatorState = session.getState(threadContext);
            int n = generatorState.increaseDepth(threadContext);
            if (rubyArray.isEmpty()) {
                outputStream.write(EMPTY_ARRAY_BYTES);
                generatorState.decreaseDepth();
                return;
            }
            Ruby ruby = threadContext.runtime;
            ByteList byteList = generatorState.getIndent();
            byte[] byArray = Utils.repeat(byteList, n);
            ByteList byteList2 = generatorState.getArrayNl();
            byte[] byArray2 = new byte[1 + byteList2.length()];
            byArray2[0] = 44;
            System.arraycopy(byteList2.unsafeBytes(), byteList2.begin(), byArray2, 1, byteList2.length());
            outputStream.write(91);
            outputStream.write(byteList2.bytes());
            boolean bl = true;
            int n2 = rubyArray.getLength();
            for (int i = 0; i < n2; ++i) {
                IRubyObject iRubyObject = rubyArray.eltInternal(i);
                if (bl) {
                    bl = false;
                } else {
                    outputStream.write(byArray2);
                }
                outputStream.write(byArray);
                Handler handler = Generator.getHandlerFor(ruby, iRubyObject);
                handler.generate(threadContext, session, iRubyObject, outputStream);
            }
            generatorState.decreaseDepth();
            if (!byteList2.isEmpty()) {
                outputStream.write(byteList2.bytes());
                outputStream.write(byArray, 0, generatorState.getDepth() * byteList.length());
            }
            outputStream.write(93);
        }
    };
    private static final byte[] EMPTY_HASH_BYTES = "{}".getBytes();
    static final Handler<RubyHash> HASH_HANDLER = new Handler<RubyHash>(){

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyHash rubyHash) {
            GeneratorState generatorState = session.getState(threadContext);
            int n = 12 + (generatorState.getDepth() + 1) * generatorState.getIndent().length() + generatorState.getSpaceBefore().length() + generatorState.getSpace().length();
            return 2 + rubyHash.size() * n;
        }

        @Override
        void generate(ThreadContext threadContext, final Session session, RubyHash rubyHash, final OutputStream outputStream) throws IOException {
            GeneratorState generatorState = session.getState(threadContext);
            int n = generatorState.increaseDepth(threadContext);
            if (rubyHash.isEmpty()) {
                outputStream.write(EMPTY_HASH_BYTES);
                generatorState.decreaseDepth();
                return;
            }
            final ByteList byteList = generatorState.getObjectNl();
            final byte[] byArray = byteList.unsafeBytes();
            final byte[] byArray2 = Utils.repeat(generatorState.getIndent(), n);
            final ByteList byteList2 = generatorState.getSpaceBefore();
            final ByteList byteList3 = generatorState.getSpace();
            outputStream.write(123);
            outputStream.write(byArray);
            boolean[] blArray = new boolean[]{true};
            rubyHash.visitAll(threadContext, (RubyHash.VisitorWithState)new RubyHash.VisitorWithState<boolean[]>(){

                public void visit(ThreadContext threadContext, RubyHash rubyHash, IRubyObject iRubyObject, IRubyObject iRubyObject2, int n, boolean[] blArray) {
                    try {
                        Handler handler;
                        if (blArray[0]) {
                            blArray[0] = false;
                        } else {
                            outputStream.write(44);
                            outputStream.write(byArray);
                        }
                        if (!byteList.isEmpty()) {
                            outputStream.write(byArray2);
                        }
                        Ruby ruby = threadContext.runtime;
                        RubyClass rubyClass = iRubyObject.getType();
                        Object object = iRubyObject instanceof RubyString ? (rubyClass == ruby.getString() ? iRubyObject : iRubyObject.callMethod(threadContext, "to_s")) : (rubyClass == ruby.getSymbol() ? iRubyObject.asString() : TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)ruby.getString(), (String)"to_s"));
                        if (object.getMetaClass() == ruby.getString()) {
                            STRING_HANDLER.generate(threadContext, session, (RubyString)object, outputStream);
                        } else {
                            Utils.ensureString(object);
                            handler = Generator.getHandlerFor(ruby, object);
                            handler.generate(threadContext, session, object, outputStream);
                        }
                        outputStream.write(byteList2.unsafeBytes());
                        outputStream.write(58);
                        outputStream.write(byteList3.unsafeBytes());
                        handler = Generator.getHandlerFor(ruby, iRubyObject2);
                        handler.generate(threadContext, session, iRubyObject2, outputStream);
                    }
                    catch (Throwable throwable) {
                        Helpers.throwException((Throwable)throwable);
                    }
                }
            }, (Object)blArray);
            generatorState.decreaseDepth();
            if (!blArray[0] && !byteList.isEmpty()) {
                outputStream.write(byArray);
            }
            outputStream.write(Utils.repeat(generatorState.getIndent(), generatorState.getDepth()));
            outputStream.write(125);
        }
    };
    static final Handler<RubyString> STRING_HANDLER = new Handler<RubyString>(){

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyString rubyString) {
            return 2 + rubyString.getByteList().length();
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyString rubyString, OutputStream outputStream) throws IOException {
            try {
                rubyString = Generator.ensureValidEncoding(threadContext, rubyString);
            }
            catch (RaiseException raiseException) {
                RubyException rubyException = Utils.buildGeneratorError(threadContext, (IRubyObject)rubyString, raiseException.getMessage());
                rubyException.setCause((IRubyObject)raiseException.getException());
                throw rubyException.toThrowable();
            }
            StringEncoder stringEncoder = session.getStringEncoder(threadContext);
            ByteList byteList = rubyString.getByteList();
            switch (rubyString.scanForCodeRange()) {
                case 16: {
                    stringEncoder.encodeASCII(threadContext, byteList, outputStream);
                    break;
                }
                case 32: {
                    stringEncoder.encode(threadContext, byteList, outputStream);
                    break;
                }
                default: {
                    throw Utils.buildGeneratorError(threadContext, (IRubyObject)rubyString, "source sequence is illegal/malformed utf-8").toThrowable();
                }
            }
        }
    };
    static final Handler<RubyBoolean> TRUE_HANDLER = new KeywordHandler<RubyBoolean>("true");
    static final Handler<RubyBoolean> FALSE_HANDLER = new KeywordHandler<RubyBoolean>("false");
    static final Handler<IRubyObject> NIL_HANDLER = new KeywordHandler<IRubyObject>("null");
    static final Handler<IRubyObject> OBJECT_HANDLER = new Handler<IRubyObject>(){

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            RubyString rubyString = iRubyObject.asString();
            return STRING_HANDLER.generateNew(threadContext, session, rubyString);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
            RubyString rubyString = iRubyObject.asString();
            STRING_HANDLER.generate(threadContext, session, rubyString, outputStream);
        }
    };
    static final Handler<IRubyObject> GENERIC_HANDLER = new Handler<IRubyObject>(){

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            GeneratorState generatorState = session.getState(threadContext);
            if (generatorState.strict()) {
                throw Utils.buildGeneratorError(threadContext, iRubyObject, iRubyObject + " not allowed in JSON").toThrowable();
            }
            if (iRubyObject.respondsTo("to_json")) {
                IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "to_json", (IRubyObject)generatorState);
                if (iRubyObject2 instanceof RubyString) {
                    return (RubyString)iRubyObject2;
                }
                throw threadContext.runtime.newTypeError("to_json must return a String");
            }
            return OBJECT_HANDLER.generateNew(threadContext, session, iRubyObject);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
            RubyString rubyString = this.generateNew(threadContext, session, iRubyObject);
            ByteList byteList = rubyString.getByteList();
            outputStream.write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
    };

    private Generator() {
        throw new RuntimeException();
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, Handler<? super T> handler) {
        Session session = new Session(null);
        return handler.generateNew(threadContext, session, t);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, Handler<? super T> handler, IRubyObject iRubyObject) {
        Session session = new Session(iRubyObject);
        return handler.generateNew(threadContext, session, t);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t) {
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return Generator.generateJson(threadContext, t, handler);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, IRubyObject iRubyObject) {
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return Generator.generateJson(threadContext, t, handler, iRubyObject);
    }

    public static <T extends IRubyObject> IRubyObject generateJson(ThreadContext threadContext, T t, GeneratorState generatorState, IRubyObject iRubyObject) {
        Session session = new Session(generatorState);
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        if (iRubyObject.isNil()) {
            return handler.generateNew(threadContext, session, t);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)new IOOutputStream(iRubyObject), 8192);
        handler.generateToBuffer(threadContext, session, t, bufferedOutputStream);
        return iRubyObject;
    }

    private static <T extends IRubyObject> Handler<? super T> getHandlerFor(Ruby ruby, T t) {
        switch (((RubyBasicObject)t).getNativeClassIndex()) {
            case NIL: {
                return NIL_HANDLER;
            }
            case TRUE: {
                return TRUE_HANDLER;
            }
            case FALSE: {
                return FALSE_HANDLER;
            }
            case FLOAT: {
                return FLOAT_HANDLER;
            }
            case FIXNUM: {
                return FIXNUM_HANDLER;
            }
            case BIGNUM: {
                return BIGNUM_HANDLER;
            }
            case STRING: {
                if (Helpers.metaclass(t) != ruby.getString()) break;
                return STRING_HANDLER;
            }
            case ARRAY: {
                if (Helpers.metaclass(t) != ruby.getArray()) break;
                return ARRAY_HANDLER;
            }
            case HASH: {
                if (Helpers.metaclass(t) != ruby.getHash()) break;
                return HASH_HANDLER;
            }
        }
        return GENERIC_HANDLER;
    }

    static RubyString ensureValidEncoding(ThreadContext threadContext, RubyString rubyString) {
        Encoding encoding = rubyString.getEncoding();
        if (encoding != USASCIIEncoding.INSTANCE && encoding != UTF8Encoding.INSTANCE) {
            if (encoding == ASCIIEncoding.INSTANCE) {
                RubyString rubyString2 = rubyString.strDup(threadContext.runtime);
                rubyString2.setEncoding((Encoding)UTF8Encoding.INSTANCE);
                switch (rubyString2.getCodeRange()) {
                    case 16: {
                        return rubyString2;
                    }
                    case 32: {
                        threadContext.runtime.getWarnings().warn("JSON.generate: UTF-8 string passed as BINARY, this will raise an encoding error in json 3.0");
                        return rubyString2;
                    }
                }
            }
            rubyString = (RubyString)rubyString.encode(threadContext, threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding((Encoding)UTF8Encoding.INSTANCE));
        }
        return rubyString;
    }

    private static class KeywordHandler<T extends IRubyObject>
    extends Handler<T> {
        private final byte[] keyword;

        private KeywordHandler(String string) {
            this.keyword = string.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, T t) {
            return this.keyword.length;
        }

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, T t) {
            return RubyString.newStringShared((Ruby)threadContext.runtime, (byte[])this.keyword);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, T t, OutputStream outputStream) throws IOException {
            outputStream.write(this.keyword);
        }
    }

    private static abstract class Handler<T extends IRubyObject> {
        private Handler() {
        }

        int guessSize(ThreadContext threadContext, Session session, T t) {
            return 4;
        }

        RubyString generateNew(ThreadContext threadContext, Session session, T t) {
            ByteListDirectOutputStream byteListDirectOutputStream = new ByteListDirectOutputStream(this.guessSize(threadContext, session, t));
            this.generateToBuffer(threadContext, session, t, byteListDirectOutputStream);
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteListDirectOutputStream.toByteListDirect((Encoding)UTF8Encoding.INSTANCE));
        }

        void generateToBuffer(ThreadContext threadContext, Session session, T t, OutputStream outputStream) {
            try {
                this.generate(threadContext, session, t, outputStream);
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw threadContext.runtime.newIOErrorFromException(iOException);
            }
        }

        abstract void generate(ThreadContext var1, Session var2, T var3, OutputStream var4) throws IOException;
    }

    static class Session {
        private GeneratorState state;
        private IRubyObject possibleState;
        private RuntimeInfo info;
        private StringEncoder stringEncoder;

        Session(GeneratorState generatorState) {
            this.state = generatorState;
        }

        Session(IRubyObject iRubyObject) {
            this.possibleState = iRubyObject == null || iRubyObject.isNil() ? null : iRubyObject;
        }

        public GeneratorState getState(ThreadContext threadContext) {
            if (this.state == null) {
                this.state = GeneratorState.fromState(threadContext, this.getInfo(threadContext), this.possibleState);
            }
            return this.state;
        }

        public RuntimeInfo getInfo(ThreadContext threadContext) {
            if (this.info == null) {
                this.info = RuntimeInfo.forRuntime(threadContext.runtime);
            }
            return this.info;
        }

        public StringEncoder getStringEncoder(ThreadContext threadContext) {
            if (this.stringEncoder == null) {
                GeneratorState generatorState = this.getState(threadContext);
                this.stringEncoder = new StringEncoder(generatorState.asciiOnly(), generatorState.scriptSafe());
            }
            return this.stringEncoder;
        }
    }
}

