/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.internal.plugins.AppEntryPoint;
import org.gradle.api.internal.plugins.MainClass;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;

public final class DefaultJavaAppStartScriptGenerationDetails
implements JavaAppStartScriptGenerationDetails {
    private final String applicationName;
    private final String optsEnvironmentVar;
    private final String exitEnvironmentVar;
    private final AppEntryPoint entryPoint;
    private final List<String> defaultJvmOpts;
    private final List<String> classpath;
    private final List<String> modulePath;
    private final String scriptRelPath;
    private final String appNameSystemProperty;

    public DefaultJavaAppStartScriptGenerationDetails(String applicationName, String optsEnvironmentVar, String exitEnvironmentVar, AppEntryPoint entryPoint, List<String> defaultJvmOpts, List<String> classpath, List<String> modulePath, String scriptRelPath, @Nullable String appNameSystemProperty) {
        this.applicationName = applicationName;
        this.optsEnvironmentVar = optsEnvironmentVar;
        this.exitEnvironmentVar = exitEnvironmentVar;
        this.entryPoint = entryPoint;
        this.defaultJvmOpts = defaultJvmOpts;
        this.classpath = classpath;
        this.modulePath = modulePath;
        this.scriptRelPath = scriptRelPath;
        this.appNameSystemProperty = appNameSystemProperty;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getOptsEnvironmentVar() {
        return this.optsEnvironmentVar;
    }

    @Override
    public String getExitEnvironmentVar() {
        return this.exitEnvironmentVar;
    }

    @Override
    public String getMainClassName() {
        if (!(this.entryPoint instanceof MainClass)) {
            throw new IllegalStateException("Entry point is not a main class: " + this.entryPoint);
        }
        return ((MainClass)this.entryPoint).getMainClassName();
    }

    public AppEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public List<String> getDefaultJvmOpts() {
        return this.defaultJvmOpts;
    }

    @Override
    public List<String> getClasspath() {
        return this.classpath;
    }

    @Override
    public List<String> getModulePath() {
        return this.modulePath;
    }

    @Override
    public String getScriptRelPath() {
        return this.scriptRelPath;
    }

    @Override
    @Nullable
    public String getAppNameSystemProperty() {
        return this.appNameSystemProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJavaAppStartScriptGenerationDetails that = (DefaultJavaAppStartScriptGenerationDetails)o;
        if (!Objects.equals(this.appNameSystemProperty, that.appNameSystemProperty)) {
            return false;
        }
        if (!Objects.equals(this.applicationName, that.applicationName)) {
            return false;
        }
        if (!Objects.equals(this.classpath, that.classpath)) {
            return false;
        }
        if (!Objects.equals(this.modulePath, that.modulePath)) {
            return false;
        }
        if (!Objects.equals(this.defaultJvmOpts, that.defaultJvmOpts)) {
            return false;
        }
        if (!Objects.equals(this.exitEnvironmentVar, that.exitEnvironmentVar)) {
            return false;
        }
        if (!Objects.equals(this.entryPoint, that.entryPoint)) {
            return false;
        }
        if (!Objects.equals(this.optsEnvironmentVar, that.optsEnvironmentVar)) {
            return false;
        }
        return Objects.equals(this.scriptRelPath, that.scriptRelPath);
    }

    public int hashCode() {
        int result = this.applicationName != null ? this.applicationName.hashCode() : 0;
        result = 31 * result + (this.optsEnvironmentVar != null ? this.optsEnvironmentVar.hashCode() : 0);
        result = 31 * result + (this.exitEnvironmentVar != null ? this.exitEnvironmentVar.hashCode() : 0);
        result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
        result = 31 * result + (this.defaultJvmOpts != null ? this.defaultJvmOpts.hashCode() : 0);
        result = 31 * result + (this.classpath != null ? this.classpath.hashCode() : 0);
        result = 31 * result + (this.modulePath != null ? this.modulePath.hashCode() : 0);
        result = 31 * result + (this.scriptRelPath != null ? this.scriptRelPath.hashCode() : 0);
        result = 31 * result + (this.appNameSystemProperty != null ? this.appNameSystemProperty.hashCode() : 0);
        return result;
    }
}

