/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.util.SyncAction;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class GLUniformData {
    private static final short BIT_MATRIX = 1;
    private static final short BIT_BUFFER = 2;
    private String name;
    private int location;
    private int rows;
    private int columns;
    private int count;
    private Object data;
    private short bits;
    private SyncAction syncAction;

    public GLUniformData(String string, int n) {
        this.initScalar(string, 1, n);
    }

    public GLUniformData(String string, float f) {
        this.initScalar(string, 1, Float.valueOf(f));
    }

    public GLUniformData(String string, int n, IntBuffer intBuffer) {
        this.initBuffer(string, n, intBuffer, null);
    }

    public GLUniformData(String string, int n, FloatBuffer floatBuffer) {
        this.initBuffer(string, n, floatBuffer, null);
    }

    public GLUniformData(String string, int n, SyncBuffer syncBuffer) {
        this.initBuffer(string, n, syncBuffer.getBuffer(), syncBuffer.getAction());
    }

    private GLUniformData(int n, String string) {
        this.initBuffer(string, n, null, null);
    }

    public static GLUniformData creatEmptyVector(String string, int n) {
        return new GLUniformData(n, string);
    }

    public static GLUniformData creatEmptyMatrix(String string, int n, int n2) {
        return new GLUniformData(string, n, n2, (FloatBuffer)null);
    }

    public GLUniformData(String string, int n, int n2, FloatBuffer floatBuffer) {
        this.initBuffer(string, n, n2, floatBuffer, null);
    }

    public GLUniformData(String string, int n, int n2, SyncBuffer syncBuffer) {
        this.initBuffer(string, n, n2, syncBuffer.getBuffer(), syncBuffer.getAction());
    }

    public GLUniformData setData(int n) {
        this.initScalar(n);
        return this;
    }

    public GLUniformData setData(float f) {
        this.initScalar(Float.valueOf(f));
        return this;
    }

    public GLUniformData setData(IntBuffer intBuffer) {
        this.initBuffer(intBuffer, null);
        return this;
    }

    public GLUniformData setData(FloatBuffer floatBuffer) {
        this.initBuffer(floatBuffer, null);
        return this;
    }

    public GLUniformData setData(SyncBuffer syncBuffer) {
        this.initBuffer(syncBuffer.getBuffer(), syncBuffer.getAction());
        return this;
    }

    public int intValue() {
        return (Integer)this.data;
    }

    public float floatValue() {
        return ((Float)this.data).floatValue();
    }

    public IntBuffer intBufferValue() {
        return (IntBuffer)this.data;
    }

    public FloatBuffer floatBufferValue() {
        return (FloatBuffer)this.data;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("GLUniformData[name ").append(this.name).append(", location ").append(this.location).append(", size ").append(this.rows).append("x").append(this.columns).append(", count ").append(this.count).append(", data ");
        if (this.isMatrix() && this.data instanceof FloatBuffer) {
            stringBuilder.append("\n");
            FloatBuffer floatBuffer = (FloatBuffer)this.getBuffer();
            for (int i = 0; i < this.count; ++i) {
                FloatUtil.matrixToString(stringBuilder, i + ": ", "%10.5f", floatBuffer, i * this.rows * this.columns, this.rows, this.columns, false);
                stringBuilder.append(",\n");
            }
        } else if (this.isBuffer()) {
            Buffers.toString((StringBuilder)stringBuilder, null, (Buffer)this.getBuffer());
        } else {
            stringBuilder.append(this.data);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private void initBuffer(String string, int n, int n2, Buffer buffer, SyncAction syncAction) {
        if (2 > n || n > 4 || 2 > n2 || n2 > 4) {
            throw new GLException("rowsXcolumns must be within [2..4]X[2..4], is: " + n + "X" + n2);
        }
        this.name = string;
        this.rows = n;
        this.columns = n2;
        this.bits = 1;
        this.location = -1;
        this.initBuffer(buffer, syncAction);
    }

    private void initScalar(String string, int n, Object object) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.bits = 0;
        this.location = -1;
        this.initScalar(object);
    }

    private void initBuffer(String string, int n, Buffer buffer, SyncAction syncAction) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.bits = 0;
        this.location = -1;
        this.initBuffer(buffer, syncAction);
    }

    private void initScalar(Object object) {
        if (object instanceof Buffer) {
            this.initBuffer((Buffer)object, null);
        } else if (null != object) {
            if (this.isMatrix()) {
                throw new GLException("Atom type not allowed for matrix : " + this);
            }
            this.count = 1;
            this.data = object;
        } else {
            this.count = 0;
            this.data = object;
        }
    }

    private void initBuffer(Buffer buffer, SyncAction syncAction) {
        if (null != buffer) {
            this.bits = (short)(this.bits | 2);
            int n = this.rows * this.columns;
            if (buffer.remaining() < n || 0 != buffer.remaining() % n) {
                throw new GLException("remaining data buffer size invalid: buffer: " + buffer.toString() + "\n\t" + this);
            }
            this.count = buffer.remaining() / n;
            this.data = buffer;
        } else {
            this.count = 0;
            this.data = null;
        }
        this.syncAction = syncAction;
    }

    public String getName() {
        return this.name;
    }

    public int getLocation() {
        return this.location;
    }

    public int setLocation(int n) {
        this.location = n;
        return n;
    }

    public int setLocation(GL2ES2 gL2ES2, int n) {
        this.location = gL2ES2.glGetUniformLocation(n, this.name);
        return this.location;
    }

    public Object getObject() {
        if (null != this.syncAction) {
            this.syncAction.sync();
        }
        return this.data;
    }

    public Buffer getBuffer() {
        if (null != this.syncAction) {
            this.syncAction.sync();
        }
        return this.data instanceof Buffer ? (Buffer)this.data : null;
    }

    public boolean isMatrix() {
        return 0 != (1 & this.bits);
    }

    public boolean isBuffer() {
        return 0 != (2 & this.bits);
    }

    public int count() {
        return this.count;
    }

    public int components() {
        return this.rows * this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }
}

