/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreatePlacementGroup
extends BaseCmd {
    private static final String STRATEGY_DESC = "The placement strategy for the group.";

    public CreatePlacementGroup(String[] args) {
        super("ec2addpgrp", "ec2-create-placement-group");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "GROUP_NAME -s STRATEGY";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"strategy");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"STRATEGY");
        OptionBuilder.withDescription((String)this.joinDescription(STRATEGY_DESC));
        options.addOption(OptionBuilder.create((String)"s"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a placement group with the name GROUP_NAME");
        System.out.println("     that uses the placement strategy STRATEGY");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("strategy");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        String strategy = this.getOptionValue("strategy");
        String groupName = this.getPlacementGroupName();
        RequestResultPair rsp = jec2.createPlacementGroup(this.getPlacementGroupName(), strategy);
        out.outputPlacementGroup(System.out, groupName, strategy, "available");
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        this.assertOptionSet("strategy");
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreatePlacementGroup(args).invoke();
    }

    protected String getPlacementGroupName() {
        String[] groupNames = this.getNonOptions();
        if (groupNames.length == 0) {
            throw new InvalidArgumentCombination("A placement group must be specified");
        }
        if (groupNames.length > 1) {
            throw new InvalidArgumentCombination("Only one placement group may be specified.");
        }
        return groupNames[0];
    }
}

