/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.SortedSet;
import nu.validator.source.SourceHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.SAXException;

public class XhtmlSourceHandler
implements SourceHandler {
    private static final char[] NEWLINE_SUBSTITUTE = new char[]{'\u21a9'};
    private static final AttributesImpl LINE_BREAK_ATTRS = new AttributesImpl();
    private final AttributesImpl attrs = new AttributesImpl();
    private final XhtmlSaxEmitter emitter;
    private final int lineOffset;
    private boolean listOpen;
    private boolean lineOpen;
    private String rangeOpen;
    private boolean charOpen;
    private int lineNumber;
    private SortedSet<Integer> oneBasedLineErrors;

    public XhtmlSourceHandler(XhtmlSaxEmitter emitter, int lineOffset) {
        this.emitter = emitter;
        this.lineOffset = lineOffset;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.maybeOpen();
        try {
            this.emitter.characters(ch, start, length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void maybeOpen() throws SAXException {
        assert (!this.lineOpen || this.listOpen);
        if (!this.listOpen) {
            this.attrs.clear();
            this.attrs.addAttribute("class", "source");
            if (this.lineOffset > 0) {
                this.attrs.addAttribute("start", Integer.toString(1 + this.lineOffset));
            }
            this.emitter.startElement("ol", this.attrs);
            this.listOpen = true;
        }
        if (!this.lineOpen) {
            ++this.lineNumber;
            this.attrs.clear();
            this.attrs.addAttribute("id", "l" + (this.lineNumber + this.lineOffset));
            if (this.oneBasedLineErrors != null && this.oneBasedLineErrors.contains(this.lineNumber)) {
                this.attrs.addAttribute("class", "b");
            }
            this.emitter.startElement("li", this.attrs);
            this.emitter.startElement("code");
            this.lineOpen = true;
            if (this.rangeOpen != null) {
                this.emitter.startElementWithClass("b", this.rangeOpen);
            }
        }
    }

    @Override
    public void endCharHilite() throws SAXException {
        if (!this.charOpen) {
            return;
        }
        this.emitter.endElement("b");
        this.charOpen = false;
    }

    @Override
    public void endRange() throws SAXException {
        assert (this.rangeOpen != null);
        this.emitter.endElement("b");
        this.rangeOpen = null;
    }

    @Override
    public void endSource() throws SAXException {
        if (this.charOpen) {
            this.endCharHilite();
        }
        assert (this.rangeOpen == null);
        if (this.lineOpen) {
            this.emitter.endElement("code");
            this.emitter.endElement("li");
        }
        if (this.listOpen) {
            this.emitter.endElement("ol");
        }
    }

    @Override
    public void newLine() throws SAXException {
        this.maybeOpen();
        if (this.charOpen) {
            this.endCharHilite();
        }
        if (this.rangeOpen != null) {
            this.emitter.endElement("b");
        }
        this.emitter.endElement("code");
        this.emitter.startElement("code", LINE_BREAK_ATTRS);
        this.emitter.characters(NEWLINE_SUBSTITUTE);
        this.emitter.endElement("code");
        this.emitter.endElement("li");
        this.lineOpen = false;
    }

    @Override
    public void startCharHilite(int oneBasedLine, int oneBasedColumn) throws SAXException {
        this.maybeOpen();
        assert (!this.charOpen);
        assert (this.lineNumber == oneBasedLine);
        this.attrs.clear();
        this.attrs.addAttribute("id", "cl" + (oneBasedLine + this.lineOffset) + "c" + oneBasedColumn);
        this.emitter.startElement("b", this.attrs);
        this.charOpen = true;
    }

    @Override
    public void startRange(int oneBasedLine, int oneBasedColumn) throws SAXException {
        this.maybeOpen();
        assert (this.rangeOpen == null);
        this.rangeOpen = "l" + (oneBasedLine + this.lineOffset) + "c" + oneBasedColumn;
        this.attrs.clear();
        this.attrs.addAttribute("id", this.rangeOpen);
        this.attrs.addAttribute("class", this.rangeOpen);
        this.emitter.startElement("b", this.attrs);
    }

    @Override
    public void startSource(String type, String encoding) throws SAXException {
        this.listOpen = false;
        this.lineOpen = false;
        this.rangeOpen = null;
        this.charOpen = false;
        this.lineNumber = 0;
        this.oneBasedLineErrors = null;
    }

    @Override
    public void setLineErrors(SortedSet<Integer> oneBasedLineErrors) throws SAXException {
        this.oneBasedLineErrors = oneBasedLineErrors;
    }

    static {
        LINE_BREAK_ATTRS.addAttribute("class", "lf");
        LINE_BREAK_ATTRS.addAttribute("title", "Line break");
    }
}

