/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.health;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AwarenessAttributeStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AwarenessAttributeStats> {
    @Nullable
    private final Integer activeShards;
    @Nullable
    private final Integer dataNodes;
    @Nullable
    private final Integer initializingShards;
    @Nullable
    private final Integer relocatingShards;
    @Nullable
    private final Integer unassignedShards;
    @Nullable
    private final Integer weight;
    public static final JsonpDeserializer<AwarenessAttributeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AwarenessAttributeStats::setupAwarenessAttributeStatsDeserializer);

    private AwarenessAttributeStats(Builder builder) {
        this.activeShards = builder.activeShards;
        this.dataNodes = builder.dataNodes;
        this.initializingShards = builder.initializingShards;
        this.relocatingShards = builder.relocatingShards;
        this.unassignedShards = builder.unassignedShards;
        this.weight = builder.weight;
    }

    public static AwarenessAttributeStats of(Function<Builder, ObjectBuilder<AwarenessAttributeStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer activeShards() {
        return this.activeShards;
    }

    @Nullable
    public final Integer dataNodes() {
        return this.dataNodes;
    }

    @Nullable
    public final Integer initializingShards() {
        return this.initializingShards;
    }

    @Nullable
    public final Integer relocatingShards() {
        return this.relocatingShards;
    }

    @Nullable
    public final Integer unassignedShards() {
        return this.unassignedShards;
    }

    @Nullable
    public final Integer weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.activeShards != null) {
            generator.writeKey("active_shards");
            generator.write(this.activeShards.intValue());
        }
        if (this.dataNodes != null) {
            generator.writeKey("data_nodes");
            generator.write(this.dataNodes.intValue());
        }
        if (this.initializingShards != null) {
            generator.writeKey("initializing_shards");
            generator.write(this.initializingShards.intValue());
        }
        if (this.relocatingShards != null) {
            generator.writeKey("relocating_shards");
            generator.write(this.relocatingShards.intValue());
        }
        if (this.unassignedShards != null) {
            generator.writeKey("unassigned_shards");
            generator.write(this.unassignedShards.intValue());
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write(this.weight.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAwarenessAttributeStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(Builder::dataNodes, JsonpDeserializer.integerDeserializer(), "data_nodes");
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
        op.add(Builder::weight, JsonpDeserializer.integerDeserializer(), "weight");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.activeShards);
        result = 31 * result + Objects.hashCode(this.dataNodes);
        result = 31 * result + Objects.hashCode(this.initializingShards);
        result = 31 * result + Objects.hashCode(this.relocatingShards);
        result = 31 * result + Objects.hashCode(this.unassignedShards);
        result = 31 * result + Objects.hashCode(this.weight);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwarenessAttributeStats other = (AwarenessAttributeStats)o;
        return Objects.equals(this.activeShards, other.activeShards) && Objects.equals(this.dataNodes, other.dataNodes) && Objects.equals(this.initializingShards, other.initializingShards) && Objects.equals(this.relocatingShards, other.relocatingShards) && Objects.equals(this.unassignedShards, other.unassignedShards) && Objects.equals(this.weight, other.weight);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AwarenessAttributeStats> {
        @Nullable
        private Integer activeShards;
        @Nullable
        private Integer dataNodes;
        @Nullable
        private Integer initializingShards;
        @Nullable
        private Integer relocatingShards;
        @Nullable
        private Integer unassignedShards;
        @Nullable
        private Integer weight;

        public Builder() {
        }

        private Builder(AwarenessAttributeStats o) {
            this.activeShards = o.activeShards;
            this.dataNodes = o.dataNodes;
            this.initializingShards = o.initializingShards;
            this.relocatingShards = o.relocatingShards;
            this.unassignedShards = o.unassignedShards;
            this.weight = o.weight;
        }

        private Builder(Builder o) {
            this.activeShards = o.activeShards;
            this.dataNodes = o.dataNodes;
            this.initializingShards = o.initializingShards;
            this.relocatingShards = o.relocatingShards;
            this.unassignedShards = o.unassignedShards;
            this.weight = o.weight;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder activeShards(@Nullable Integer value) {
            this.activeShards = value;
            return this;
        }

        @Nonnull
        public final Builder dataNodes(@Nullable Integer value) {
            this.dataNodes = value;
            return this;
        }

        @Nonnull
        public final Builder initializingShards(@Nullable Integer value) {
            this.initializingShards = value;
            return this;
        }

        @Nonnull
        public final Builder relocatingShards(@Nullable Integer value) {
            this.relocatingShards = value;
            return this;
        }

        @Nonnull
        public final Builder unassignedShards(@Nullable Integer value) {
            this.unassignedShards = value;
            return this;
        }

        @Nonnull
        public final Builder weight(@Nullable Integer value) {
            this.weight = value;
            return this;
        }

        @Override
        @Nonnull
        public AwarenessAttributeStats build() {
            this._checkSingleUse();
            return new AwarenessAttributeStats(this);
        }
    }
}

