/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.action.CachesStatsAction;
import com.o19s.es.ltr.action.ClearCachesAction;
import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestBuilderListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestFeatureStoreCaches
extends FeatureStoreBaseRestHandler {
    public String getName() {
        return "Provides clear cached for stores";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_ltr/_clearcache"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}/_clearcache"), new RestHandler.Route(RestRequest.Method.GET, "/_ltr/_cachestats")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        if (request.method() == RestRequest.Method.POST) {
            return this.clearCache(request, client);
        }
        return this.getStats(client);
    }

    private BaseRestHandler.RestChannelConsumer getStats(NodeClient client) {
        return channel -> client.execute((ActionType)CachesStatsAction.INSTANCE, (ActionRequest)new CachesStatsAction.CachesStatsNodesRequest(), (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private BaseRestHandler.RestChannelConsumer clearCache(RestRequest request, NodeClient client) {
        String storeName = this.indexName(request);
        ClearCachesAction.ClearCachesNodesRequest cacheRequest = new ClearCachesAction.ClearCachesNodesRequest();
        cacheRequest.clearStore(storeName);
        return channel -> client.execute((ActionType)ClearCachesAction.INSTANCE, (ActionRequest)cacheRequest, (ActionListener)new RestBuilderListener<ClearCachesAction.ClearCachesNodesResponse>(this, channel){

            public RestResponse buildResponse(ClearCachesAction.ClearCachesNodesResponse clearCachesNodesResponse, XContentBuilder builder) throws Exception {
                builder.startObject().field("acknowledged", true);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

