/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.feature.store.FeatureNormDefinition;
import com.o19s.es.ltr.feature.store.StoredFeatureNormalizers;
import com.o19s.es.ltr.ranker.normalizer.MinMaxFeatureNormalizer;
import com.o19s.es.ltr.ranker.normalizer.Normalizer;
import java.io.IOException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class MinMaxFeatureNormDefinition
implements FeatureNormDefinition {
    private static final String NAME = "min_max";
    private float minimum;
    private float maximum;
    private final String featureName;
    public static final ObjectParser<MinMaxFeatureNormDefinition, String> PARSER;
    private static final ParseField MINIMUM;
    private static final ParseField MAXIMUM;

    public MinMaxFeatureNormDefinition(StreamInput input) throws IOException {
        this.featureName = input.readString();
        this.minimum = input.readFloat();
        this.maximum = input.readFloat();
    }

    public MinMaxFeatureNormDefinition(String featureName) {
        this.featureName = featureName;
        this.maximum = Float.MAX_VALUE;
        this.minimum = 0.0f;
    }

    @Override
    public Normalizer createFeatureNorm() {
        return new MinMaxFeatureNormalizer(this.minimum, this.maximum);
    }

    @Override
    public String featureName() {
        return this.featureName;
    }

    @Override
    public StoredFeatureNormalizers.Type normType() {
        return StoredFeatureNormalizers.Type.MIN_MAX;
    }

    public void setMinimum(float min) {
        if (min >= this.maximum) {
            throw new IllegalArgumentException("Minimum " + Float.toString(min) + " must be smaller than than maximum");
        }
        if (min < 0.0f) {
            throw new IllegalArgumentException("Minimum " + Float.toString(min) + " must be positive");
        }
        this.minimum = min;
    }

    public void setMaximum(float max) {
        if (max <= this.minimum) {
            throw new IllegalArgumentException("Maximum " + Float.toString(max) + " must be larger than minimum");
        }
        if (max < 0.0f) {
            throw new IllegalArgumentException("Maximum " + Float.toString(max) + " must be positive");
        }
        this.maximum = max;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeFloat(this.minimum);
        out.writeFloat(this.maximum);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME);
        builder.startObject();
        builder.field(MINIMUM.getPreferredName(), this.minimum);
        builder.field(MAXIMUM.getPreferredName(), this.maximum);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MinMaxFeatureNormDefinition)) {
            return false;
        }
        MinMaxFeatureNormDefinition that = (MinMaxFeatureNormDefinition)o;
        if (!this.featureName.equals(that.featureName)) {
            return false;
        }
        if (this.minimum != that.minimum) {
            return false;
        }
        return this.maximum == that.maximum;
    }

    public int hashCode() {
        int hash = this.featureName.hashCode();
        hash = hash * 31 + Float.hashCode(this.minimum);
        hash = hash * 31 + Float.hashCode(this.maximum);
        return hash;
    }

    static {
        MINIMUM = new ParseField("minimum", new String[0]);
        MAXIMUM = new ParseField("maximum", new String[0]);
        PARSER = ObjectParser.fromBuilder((String)NAME, MinMaxFeatureNormDefinition::new);
        PARSER.declareFloat(MinMaxFeatureNormDefinition::setMinimum, MINIMUM);
        PARSER.declareFloat(MinMaxFeatureNormDefinition::setMaximum, MAXIMUM);
    }
}

