/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;

public class OperationParser {
    public static final String COMPONENTS_REF = "#/components/schemas/";

    public static Optional<RequestBody> getRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, Consumes classConsumes, Consumes methodConsumes, Components components, JsonView jsonViewAnnotation) {
        return OperationParser.getRequestBody(requestBody, classConsumes, methodConsumes, components, jsonViewAnnotation, false);
    }

    public static Optional<RequestBody> getRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, Consumes classConsumes, Consumes methodConsumes, Components components, JsonView jsonViewAnnotation, boolean openapi31) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((boolean)openapi31, (Extension[])requestBody.extensions());
            if (extensions != null) {
                extensions.forEach((arg_0, arg_1) -> ((RequestBody)requestBodyObject).addExtension(arg_0, arg_1));
            }
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), null, (Components)components, (JsonView)jsonViewAnnotation, (boolean)openapi31).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public static Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, Produces classProduces, Produces methodProduces, Components components, JsonView jsonViewAnnotation) {
        return OperationParser.getApiResponses(responses, classProduces, methodProduces, components, jsonViewAnnotation, false);
    }

    public static Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, Produces classProduces, Produces methodProduces, Components components, JsonView jsonViewAnnotation, boolean openapi31) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            Map extensions;
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.ref())) {
                apiResponseObject.set$ref(response.ref());
                if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                    apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                    continue;
                }
                apiResponsesObject._default(apiResponseObject);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            if (response.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((boolean)openapi31, (Extension[])response.extensions())) != null) {
                extensions.forEach((arg_0, arg_1) -> ((ApiResponse)apiResponseObject).addExtension(arg_0, arg_1));
            }
            AnnotationsUtils.getContent((Content[])response.content(), (String[])(classProduces == null ? new String[]{} : classProduces.value()), (String[])(methodProduces == null ? new String[]{} : methodProduces.value()), null, (Components)components, (JsonView)jsonViewAnnotation, (boolean)openapi31).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).content(arg_0));
            AnnotationsUtils.getHeaders((Header[])response.headers(), (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).headers(arg_0));
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null && apiResponseObject.getHeaders() == null) continue;
            Map links = AnnotationsUtils.getLinks((Link[])response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(apiResponsesObject);
    }
}

