/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryBufferCreateInfo;

public class VkExternalMemoryBufferCreateInfoKHR
extends VkExternalMemoryBufferCreateInfo {
    public VkExternalMemoryBufferCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR sType$Default() {
        return this.sType(1000072000);
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHR set(VkExternalMemoryBufferCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfoKHR malloc() {
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR calloc() {
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExternalMemoryBufferCreateInfoKHR create(long address) {
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExternalMemoryBufferCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryBufferCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR mallocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR callocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkExternalMemoryBufferCreateInfoKHR malloc(MemoryStack stack) {
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR calloc(MemoryStack stack) {
        return (VkExternalMemoryBufferCreateInfoKHR)VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkExternalMemoryBufferCreateInfo.Buffer {
        private static final VkExternalMemoryBufferCreateInfoKHR ELEMENT_FACTORY = VkExternalMemoryBufferCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalMemoryBufferCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000072000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

