/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ComparableOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;

public final class StringBuilderOps
extends ObjectOps
implements ComparableOps {
    private static Var declare(Expr obj, BlockCreator bc) {
        Var var;
        return obj instanceof Var ? (var = (Var)obj) : bc.localVar("$$stringBuilder", obj);
    }

    public StringBuilderOps(BlockCreator bc, Expr obj) {
        super(StringBuilder.class, bc, StringBuilderOps.declare(obj, bc));
    }

    public StringBuilderOps(BlockCreator bc) {
        super(StringBuilder.class, bc, StringBuilderOps.declare(bc.new_(StringBuilder.class, new Expr[0]), bc));
    }

    public StringBuilderOps(BlockCreator bc, int capacity) {
        super(StringBuilder.class, bc, StringBuilderOps.declare(bc.new_(StringBuilder.class, Const.of(capacity)), bc));
    }

    public StringBuilderOps append(Expr expr) {
        switch (expr.type().descriptorString()) {
            case "Z": {
                this.invokeInstance(StringBuilder.class, "append", Boolean.TYPE, expr);
                break;
            }
            case "B": 
            case "S": 
            case "I": {
                this.invokeInstance(StringBuilder.class, "append", Integer.TYPE, expr);
                break;
            }
            case "J": {
                this.invokeInstance(StringBuilder.class, "append", Long.TYPE, expr);
                break;
            }
            case "F": {
                this.invokeInstance(StringBuilder.class, "append", Float.TYPE, expr);
                break;
            }
            case "D": {
                this.invokeInstance(StringBuilder.class, "append", Double.TYPE, expr);
                break;
            }
            case "C": {
                this.invokeInstance(StringBuilder.class, "append", Character.TYPE, expr);
                break;
            }
            case "[C": {
                this.invokeInstance(StringBuilder.class, "append", char[].class, expr);
                break;
            }
            case "Ljava/lang/String;": {
                this.invokeInstance(StringBuilder.class, "append", String.class, expr);
                break;
            }
            case "Ljava/lang/CharSequence;": {
                this.invokeInstance(StringBuilder.class, "append", CharSequence.class, expr);
                break;
            }
            default: {
                this.invokeInstance(StringBuilder.class, "append", Object.class, expr);
            }
        }
        return this;
    }

    public StringBuilderOps append(char constant) {
        return this.append(Const.of(constant));
    }

    public StringBuilderOps append(String constant) {
        return this.append(Const.of(constant));
    }

    public StringBuilderOps appendCodePoint(Expr codePoint) {
        this.invokeInstance(StringBuilder.class, "appendCodePoint", Integer.TYPE, codePoint);
        return this;
    }

    public StringBuilderOps appendCodePoint(int codePoint) {
        return this.appendCodePoint(Const.of(codePoint));
    }

    public void setLength(Expr length) {
        this.invokeInstance(Void.TYPE, "setLength", Integer.TYPE, length);
    }

    public void setLength(int length) {
        this.setLength(Const.of(length));
    }

    @Override
    public Expr compareTo(Expr other) {
        return this.invokeInstance(Integer.TYPE, "compareTo", StringBuilder.class, other);
    }
}

