/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.spi.infinispan.impl.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.config.CachingOptions;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.spi.infinispan.CacheRemoteConfigProvider;
import org.keycloak.spi.infinispan.CacheRemoteConfigProviderFactory;
import org.keycloak.spi.infinispan.impl.Util;

public class DefaultCacheRemoteConfigProviderFactory
implements CacheRemoteConfigProviderFactory,
CacheRemoteConfigProvider,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "default";
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PROPERTIES_FILE = "propertiesFile";
    private static final String CLIENT_INTELLIGENCE = "clientIntelligence";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    private static final String TLS_ENABLED = "tlsEnabled";
    private static final String TLS_SNI_HOSTNAME = "tlsSniHostname";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CONNECTION_POOL_MAX_ACTIVE = "connectionPoolMaxActive";
    private static final String CONNECTION_POOL_EXHAUSTED_ACTION = "connectionPoolExhaustedAction";
    private static final String AUTH_REALM = "authRealm";
    private static final String SASL_MECHANISM = "saslMechanism";
    private static final String CLIENT_INTELLIGENCE_DEFAULT = ClientIntelligence.getDefault().name();
    private static final int CONNECTION_POOL_MAX_ACTIVE_DEFAULT = 16;
    private static final String CONNECTION_POOL_EXHAUSTED_ACTION_DEFAULT = ExhaustedAction.CREATE_NEW.name();
    private static final String SASL_MECHANISM_DEFAULT = "SCRAM-SHA-512";
    private volatile Configuration remoteConfiguration;
    private volatile Config.Scope keycloakConfiguration;

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public CacheRemoteConfigProvider create(KeycloakSession session) {
        this.lazyInit();
        return this;
    }

    public void init(Config.Scope config) {
        this.keycloakConfiguration = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.lazyInit();
    }

    @Override
    public Optional<Configuration> configuration() {
        assert (this.remoteConfiguration != null);
        return Optional.of(this.remoteConfiguration);
    }

    @Override
    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        DefaultCacheRemoteConfigProviderFactory.addHostNameAndPortConfig(builder);
        DefaultCacheRemoteConfigProviderFactory.addClientIntelligenceConfig(builder);
        DefaultCacheRemoteConfigProviderFactory.addPropertiesFileConfig(builder);
        DefaultCacheRemoteConfigProviderFactory.addConnectionPoolConfig(builder);
        DefaultCacheRemoteConfigProviderFactory.addTlsConfig(builder);
        DefaultCacheRemoteConfigProviderFactory.addAuthenticationConfig(builder);
        return builder.build();
    }

    protected ConfigurationBuilder createConfigurationBuilder() throws IOException {
        logger.info((Object)"Starting Infinispan remote cache manager (Hot Rod Client)");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.loadProperties(builder);
        builder.clientIntelligence(ClientIntelligence.valueOf((String)this.keycloakConfiguration.get(CLIENT_INTELLIGENCE, CLIENT_INTELLIGENCE_DEFAULT)));
        this.configureHostname(builder);
        this.configureConnectionPool(builder);
        this.configureTls(builder);
        this.configureAuthentication(builder);
        Marshalling.configure(builder);
        DefaultCacheRemoteConfigProviderFactory.configureRemoteCaches(builder);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.remoteConfiguration != null) {
            return;
        }
        DefaultCacheRemoteConfigProviderFactory defaultCacheRemoteConfigProviderFactory = this;
        synchronized (defaultCacheRemoteConfigProviderFactory) {
            if (this.remoteConfiguration != null) {
                return;
            }
            try {
                this.remoteConfiguration = this.createConfigurationBuilder().build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadProperties(ConfigurationBuilder builder) throws IOException {
        String path = this.keycloakConfiguration.get(PROPERTIES_FILE);
        if (path == null) {
            logger.debug((Object)"Hot Rod properties file not configured.");
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("Hot Rod properties file not found: " + path);
        }
        try (FileInputStream is = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(is);
            builder.withProperties(properties);
        }
    }

    private void configureHostname(ConfigurationBuilder builder) {
        String host = this.keycloakConfiguration.get(HOSTNAME);
        if (host == null) {
            logger.debug((Object)"Hot Rod hostname not configured.");
            return;
        }
        Integer port = this.keycloakConfiguration.getInt(PORT, Integer.valueOf(11222));
        logger.debugf("Hot Rod connecting to %s:%s", (Object)host, (Object)port);
        builder.addServer().host(host).port(port.intValue());
    }

    private void configureConnectionPool(ConfigurationBuilder builder) {
        builder.connectionPool().maxActive(this.keycloakConfiguration.getInt(CONNECTION_POOL_MAX_ACTIVE, Integer.valueOf(16)).intValue()).exhaustedAction(ExhaustedAction.valueOf((String)this.keycloakConfiguration.get(CONNECTION_POOL_EXHAUSTED_ACTION, CONNECTION_POOL_EXHAUSTED_ACTION_DEFAULT)));
    }

    private void configureTls(ConfigurationBuilder builder) {
        if (!this.keycloakConfiguration.getBoolean(TLS_ENABLED, Boolean.FALSE).booleanValue()) {
            logger.debug((Object)"Hot Rod TLS not enabled.");
            return;
        }
        String sniHostName = this.keycloakConfiguration.get(TLS_SNI_HOSTNAME);
        if (sniHostName == null) {
            sniHostName = this.keycloakConfiguration.get(HOSTNAME);
        }
        builder.security().ssl().enable().sslContext(DefaultCacheRemoteConfigProviderFactory.createSSLContext()).sniHostName(sniHostName);
    }

    private void configureAuthentication(ConfigurationBuilder builder) {
        String username = this.keycloakConfiguration.get(USERNAME);
        String password = this.keycloakConfiguration.get(PASSWORD);
        if (username == null && password == null) {
            logger.debug((Object)"Hot Rod authentication not enabled.");
            return;
        }
        builder.security().authentication().enable().username(username).password(password).realm(this.keycloakConfiguration.get(AUTH_REALM, PROVIDER_ID)).saslMechanism(this.keycloakConfiguration.get(SASL_MECHANISM, SASL_MECHANISM_DEFAULT));
    }

    private static SSLContext createSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean shouldCreateRemoteCaches() {
        return Boolean.getBoolean("kc.cache-remote-create-caches");
    }

    private static void configureRemoteCaches(ConfigurationBuilder builder) {
        if (!DefaultCacheRemoteConfigProviderFactory.shouldCreateRemoteCaches()) {
            return;
        }
        logger.warn((Object)"Creating remote cache in external Infinispan server. It should not be used in production!");
        org.infinispan.configuration.cache.Configuration baseConfig = DefaultCacheRemoteConfigProviderFactory.defaultRemoteCacheBuilder();
        InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES)).forEach(name -> builder.remoteCache(name).configuration(baseConfig.toStringConfiguration(name)));
    }

    private static org.infinispan.configuration.cache.Configuration defaultRemoteCacheBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.encoding().mediaType(MediaType.APPLICATION_PROTOSTREAM);
        return builder.build();
    }

    private static void addHostNameAndPortConfig(ProviderConfigurationBuilder builder) {
        Util.copyFromOption(builder, HOSTNAME, HOSTNAME, "String", CachingOptions.CACHE_REMOTE_HOST, false);
        Util.copyFromOption(builder, PORT, PORT, "Integer", CachingOptions.CACHE_REMOTE_PORT, false);
    }

    private static void addClientIntelligenceConfig(ProviderConfigurationBuilder builder) {
        builder.property().name(CLIENT_INTELLIGENCE).helpText("Specifies the level of intelligence the Hot Rod client should have.").label("intelligence").type("String").defaultValue((Object)CLIENT_INTELLIGENCE_DEFAULT).options(Arrays.stream(ClientIntelligence.values()).map(Enum::name).toList()).add();
    }

    private static void addPropertiesFileConfig(ProviderConfigurationBuilder builder) {
        builder.property().name(PROPERTIES_FILE).helpText("Path to the properties file with the Hot Rod client configuration.").label("file").type("File").add();
    }

    private static void addConnectionPoolConfig(ProviderConfigurationBuilder builder) {
        builder.property().name(CONNECTION_POOL_MAX_ACTIVE).helpText("Sets the maximum number of connections per Infinispan server instance.").label("maxActive").type("Integer").defaultValue((Object)16).add();
        builder.property().name(CONNECTION_POOL_EXHAUSTED_ACTION).helpText("Specifies what happens when asking for a connection from a server's pool, and that pool is exhausted.").label("action").type("String").defaultValue((Object)CONNECTION_POOL_EXHAUSTED_ACTION_DEFAULT).options(Arrays.stream(ExhaustedAction.values()).map(Enum::name).toList()).add();
    }

    private static void addAuthenticationConfig(ProviderConfigurationBuilder builder) {
        Util.copyFromOption(builder, USERNAME, USERNAME, "String", CachingOptions.CACHE_REMOTE_USERNAME, false);
        Util.copyFromOption(builder, PASSWORD, PASSWORD, "String", CachingOptions.CACHE_REMOTE_PASSWORD, true);
        builder.property().name(AUTH_REALM).helpText("Specifies the Infinispan server realm to be used for authentication.").label("realm").type("String").defaultValue((Object)PROVIDER_ID).add();
        builder.property().name(SASL_MECHANISM).helpText("Selects the SASL mechanism to use for the connection to the Infinispan server.").label("mechanism").type("String").defaultValue((Object)SASL_MECHANISM_DEFAULT).add();
    }

    private static void addTlsConfig(ProviderConfigurationBuilder builder) {
        Util.copyFromOption(builder, TLS_ENABLED, "enabled", "boolean", CachingOptions.CACHE_REMOTE_TLS_ENABLED, false);
        builder.property().name(TLS_SNI_HOSTNAME).helpText("Specifies the TLS SNI hostname for the connection to the Infinispan server.").label(HOSTNAME).type("String").add();
    }
}

