/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.Images;

public class PictImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;
    public static final DataFlavor PICT_FLAVOR;

    public PictImageInputFormat(ImageHolderFigure imageHolderFigure) {
        this(imageHolderFigure, "PICT", "PICT (pct)", "pct", 2);
    }

    private PictImageInputFormat(ImageHolderFigure imageHolderFigure, String string, String string2, String string3, int n) {
        this.prototype = imageHolderFigure;
        this.formatName = string;
        this.description = string2;
        this.fileExtension = string3;
        this.imageType = n;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing, boolean bl) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            Image image = PictImageInputFormat.getImageFromPictStream(inputStream);
            if (image == null) {
                throw new IOException("Couldn't read pict image");
            }
            ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
            imageHolderFigure.setBufferedImage(Images.toBufferedImage(image));
            imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
            if (bl) {
                drawing.removeAllChildren();
            }
            drawing.basicAdd(imageHolderFigure);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(InputStream inputStream, Drawing drawing, boolean bl) throws IOException {
        try {
            Image image = PictImageInputFormat.getImageFromPictStream(inputStream);
            if (image == null) {
                throw new IOException("Couldn't read pict image");
            }
            ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
            imageHolderFigure.setBufferedImage(Images.toBufferedImage(image));
            imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
            if (bl) {
                drawing.removeAllChildren();
            }
            drawing.basicAdd(imageHolderFigure);
        }
        finally {
            inputStream.close();
        }
    }

    public ImageHolderFigure createImageHolder(InputStream inputStream) throws IOException {
        ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
        imageHolderFigure.setBufferedImage(Images.toBufferedImage(PictImageInputFormat.getImageFromPictStream(inputStream)));
        imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
        return imageHolderFigure;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(PICT_FLAVOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Transferable transferable, Drawing drawing, boolean bl) throws UnsupportedFlavorException, IOException {
        Object object = transferable.getTransferData(PICT_FLAVOR);
        if (object instanceof InputStream) {
            InputStream inputStream = null;
            try {
                inputStream = (InputStream)object;
                Image image = PictImageInputFormat.getImageFromPictStream(inputStream);
                if (image == null) {
                    throw new IOException("Couldn't read pict image");
                }
                ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
                imageHolderFigure.setBufferedImage(Images.toBufferedImage(image));
                imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
                if (bl) {
                    drawing.removeAllChildren();
                }
                drawing.add(imageHolderFigure);
            }
            finally {
                inputStream.close();
            }
        }
    }

    private static Image getImageFromPictStream(InputStream inputStream) throws IOException {
        Object object;
        try {
            Class<?> clazz;
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[512];
            byte[] byArray2 = new byte[4096];
            int n = 0;
            int n2 = 0;
            ((ByteArrayOutputStream)object).write(byArray, 0, 512);
            while ((n = inputStream.read(byArray2, 0, 4096)) > 0) {
                ((ByteArrayOutputStream)object).write(byArray2, 0, n);
            }
            ((ByteArrayOutputStream)object).close();
            n2 = ((ByteArrayOutputStream)object).size();
            if (n2 <= 0) {
                return null;
            }
            byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
            try {
                clazz = Class.forName("quicktime.QTSession");
            }
            catch (Throwable throwable) {
                IOException iOException = new IOException("QuickTime for Java is not available.");
                iOException.initCause(throwable);
                throw iOException;
            }
            Method method = clazz.getMethod("isInitialized", new Class[0]);
            Boolean bl = (Boolean)method.invoke(null, (Object[])null);
            if (!bl.booleanValue()) {
                method = clazz.getMethod("open", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            clazz = Class.forName("quicktime.util.QTHandle");
            Constructor<?> constructor = clazz.getConstructor(byArray3.getClass());
            Object obj = constructor.newInstance(new Object[]{byArray3});
            String string = new String("PICT");
            clazz = Class.forName("quicktime.util.QTUtils");
            method = clazz.getMethod("toOSType", string.getClass());
            Integer n3 = (Integer)method.invoke(null, string);
            clazz = Class.forName("quicktime.std.image.GraphicsImporter");
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            constructor = clazz.getConstructor(classArray);
            Object obj2 = constructor.newInstance(n3);
            method = clazz.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            method.invoke(obj2, obj);
            method = clazz.getMethod("getNaturalBounds", new Class[0]);
            Object object2 = method.invoke(obj2, new Object[0]);
            clazz = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            constructor = clazz.getConstructor(obj2.getClass());
            Object obj3 = constructor.newInstance(obj2);
            method = object2.getClass().getMethod("getWidth", new Class[0]);
            Integer n4 = (Integer)method.invoke(object2, new Object[0]);
            method = object2.getClass().getMethod("getHeight", new Class[0]);
            Integer n5 = (Integer)method.invoke(object2, new Object[0]);
            Dimension dimension = new Dimension(n4, n5);
            clazz = Class.forName("quicktime.app.view.QTImageProducer");
            constructor = clazz.getConstructor(obj3.getClass(), dimension.getClass());
            Object obj4 = constructor.newInstance(obj3, dimension);
            if (obj4 instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)obj4);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Couldn't read PICT image");
            iOException.initCause(exception);
            throw iOException;
        }
        object = new IOException("Couldn't read PICT image");
        throw object;
    }

    static {
        try {
            PICT_FLAVOR = new DataFlavor("image/x-pict");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("Unable to create data flavor image/x-pict");
        }
    }
}

