/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class ChooseFoundingFatherMessage
extends AttributeMessage {
    public static final String TAG = "chooseFoundingFather";
    private static final String FOUNDING_FATHER_TAG = "foundingFather";
    private static final List<String> fatherKeys = Collections.unmodifiableList(CollectionUtils.transform(FoundingFather.FoundingFatherType.values(), CollectionUtils.alwaysTrue(), FoundingFather.FoundingFatherType::getKey));

    public ChooseFoundingFatherMessage(List<FoundingFather> fathers, FoundingFather ff) {
        super(TAG);
        this.setFatherAttributes(fathers);
        if (ff != null) {
            this.setStringAttribute(FOUNDING_FATHER_TAG, ff.getId());
        }
    }

    public ChooseFoundingFatherMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, ChooseFoundingFatherMessage.getAttributeMap(xr));
        xr.closeTag(TAG);
    }

    private void setFatherAttributes(List<FoundingFather> fathers) {
        this.setStringAttributeMap(CollectionUtils.transform(fathers, CollectionUtils.alwaysTrue(), Function.identity(), Collectors.toMap(ff -> ff.getType().getKey(), FreeColObject::getId)));
    }

    private static Map<String, String> getAttributeMap(FreeColXMLReader xr) {
        HashMap<String, String> ret = new HashMap<String, String>(fatherKeys.size());
        for (String key : fatherKeys) {
            String val = xr.getAttribute(key, null);
            ret.put(key, val);
        }
        String ffk = xr.getAttribute(FOUNDING_FATHER_TAG, null);
        if (ffk != null) {
            ret.put(FOUNDING_FATHER_TAG, ffk);
        }
        return ret;
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.EARLY;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        List<FoundingFather> fathers = this.getFathers(game);
        aiPlayer.chooseFoundingFatherHandler(fathers);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        List<FoundingFather> fathers = this.getFathers(game);
        this.igc(freeColClient).chooseFoundingFatherHandler(fathers);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerGame game = freeColServer.getGame();
        FoundingFather ff = this.getFather(game);
        if (ff == null) {
            return serverPlayer.clientError("No founding father selected");
        }
        return this.igc(freeColServer).chooseFoundingFather(serverPlayer, ff);
    }

    public final FoundingFather getFather(Game game) {
        String id = this.getStringAttribute(FOUNDING_FATHER_TAG);
        return id == null ? null : game.getSpecification().getFoundingFather(id);
    }

    public final ChooseFoundingFatherMessage setFather(FoundingFather ff) {
        this.setStringAttribute(FOUNDING_FATHER_TAG, ff == null ? null : ff.getId());
        return this;
    }

    public final List<FoundingFather> getFathers(Game game) {
        Specification spec = game.getSpecification();
        return CollectionUtils.transform(fatherKeys, tid -> this.hasAttribute((String)tid), tid -> spec.getFoundingFather(this.getStringAttribute((String)tid)));
    }
}

