/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.sf.freecol.common.i18n.Merge;
import net.sf.freecol.common.i18n.MergeTableCellRenderer;
import net.sf.freecol.common.i18n.MergeTableModel;

public final class MessageMerge {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("use: MessageMerge path-to-file-1 path-to-file-2");
            System.exit(1);
        }
        String pathToFile1 = args[0];
        final String pathToFile2 = args[1];
        final MergeTableModel mergeTableModel = new MergeTableModel();
        mergeTableModel.merge = new Merge(MessageMerge.loadLinesFromFile(pathToFile1), MessageMerge.loadLinesFromFile(pathToFile2));
        final JTable mergeTable = new JTable(mergeTableModel);
        mergeTable.setSelectionMode(1);
        mergeTable.setDefaultRenderer(Object.class, new MergeTableCellRenderer());
        AbstractAction insertInRightAction = new AbstractAction("insert in right"){

            @Override
            public void actionPerformed(ActionEvent event) {
                int from = mergeTable.getSelectionModel().getMinSelectionIndex();
                int to = mergeTable.getSelectionModel().getMaxSelectionIndex();
                mergeTableModel.insertInRight(from, to);
            }
        };
        AbstractAction deleteFromRightAction = new AbstractAction("delete from right"){

            @Override
            public void actionPerformed(ActionEvent event) {
                int from = mergeTable.getSelectionModel().getMinSelectionIndex();
                int to = mergeTable.getSelectionModel().getMaxSelectionIndex();
                mergeTableModel.deleteFromRight(from, to);
            }
        };
        AbstractAction saveRightAction = new AbstractAction("save right"){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessageMerge.saveLinesToFile(mergeTableModel.merge.lineFromFile2, pathToFile2);
            }
        };
        JPanel controlPanel = new JPanel(new GridLayout(1, 3));
        controlPanel.add(new JButton(insertInRightAction));
        controlPanel.add(new JButton(deleteFromRightAction));
        controlPanel.add(new JButton(saveRightAction));
        JPanel rootPane = new JPanel(new BorderLayout());
        rootPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        rootPane.add((Component)new JScrollPane(mergeTable), "Center");
        rootPane.add((Component)controlPanel, "South");
        JFrame frame = new JFrame("MessageMerge");
        frame.getContentPane().add(rootPane);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent event) {
                this.windowClosing(event);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private static List<String> loadLinesFromFile(String pathToFile) {
        ArrayList<String> arrayList;
        block11: {
            ArrayList<String> lineList = new ArrayList<String>();
            InputStream in = Files.newInputStream(Paths.get(pathToFile, new String[0]), new OpenOption[0]);
            try {
                StringBuilder line = new StringBuilder();
                while (true) {
                    int data;
                    if (-1 == (data = in.read())) {
                        if (0 >= line.length()) break;
                        lineList.add(line.toString());
                        break;
                    }
                    char c = (char)data;
                    if ('\r' == c) continue;
                    if ('\n' == c) {
                        lineList.add(line.toString());
                        line.setLength(0);
                        continue;
                    }
                    line.append(c);
                }
                in.close();
                arrayList = lineList;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            in.close();
        }
        return arrayList;
    }

    private static void saveLinesToFile(List<String> lineList, String pathToFile) {
        try (OutputStream out = Files.newOutputStream(Paths.get(pathToFile, new String[0]), new OpenOption[0]);){
            int lines = lineList.size();
            for (int lineNumber = 0; lineNumber < lines; ++lineNumber) {
                String line = lineList.get(lineNumber);
                for (int i = 0; i < line.length(); ++i) {
                    out.write(line.charAt(i));
                }
                out.write(10);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

