/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) | (- 0u)) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) | (- 6u)) => uvec4(4294967290u, 4294967290u, 4294967295u, 4294967291u)
 * (uvec4(66u, 72u, 87u, 75u) | (- 12u)) => uvec4(4294967286u, 4294967292u, 4294967287u, 4294967295u)
 * (uvec4(66u, 72u, 87u, 75u) | (- 32u)) => uvec4(4294967266u, 4294967272u, 4294967287u, 4294967275u)
 * (uvec4(66u, 72u, 87u, 75u) | (- 74u)) => uvec4(4294967286u, 4294967294u, 4294967287u, 4294967295u)
 * (uvec4(24u, 40u, 23u, 74u) | (- 0u)) => uvec4(24u, 40u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) | (- 6u)) => uvec4(4294967290u, 4294967290u, 4294967295u, 4294967290u)
 * (uvec4(24u, 40u, 23u, 74u) | (- 12u)) => uvec4(4294967292u, 4294967292u, 4294967287u, 4294967294u)
 * (uvec4(24u, 40u, 23u, 74u) | (- 32u)) => uvec4(4294967288u, 4294967272u, 4294967287u, 4294967274u)
 * (uvec4(24u, 40u, 23u, 74u) | (- 74u)) => uvec4(4294967230u, 4294967230u, 4294967223u, 4294967294u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | (- 0u)), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | (- 6u)), uvec4(4294967290u, 4294967290u, 4294967295u, 4294967291u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | (- 12u)), uvec4(4294967286u, 4294967292u, 4294967287u, 4294967295u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | (- 32u)), uvec4(4294967266u, 4294967272u, 4294967287u, 4294967275u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | (- 74u)), uvec4(4294967286u, 4294967294u, 4294967287u, 4294967295u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | (- 0u)), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | (- 6u)), uvec4(4294967290u, 4294967290u, 4294967295u, 4294967290u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | (- 12u)), uvec4(4294967292u, 4294967292u, 4294967287u, 4294967294u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | (- 32u)), uvec4(4294967288u, 4294967272u, 4294967287u, 4294967274u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | (- 74u)), uvec4(4294967230u, 4294967230u, 4294967223u, 4294967294u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
