/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkClearValue;
import org.lwjgl.vulkan.VkRenderingAttachmentInfo;

public class VkRenderingAttachmentInfoKHR
extends VkRenderingAttachmentInfo {
    public VkRenderingAttachmentInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderingAttachmentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingAttachmentInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR sType$Default() {
        return this.sType(1000044001);
    }

    @Override
    public VkRenderingAttachmentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderingAttachmentInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR imageView(@NativeType(value="VkImageView") long value) {
        VkRenderingAttachmentInfoKHR.nimageView(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR imageLayout(@NativeType(value="VkImageLayout") int value) {
        VkRenderingAttachmentInfoKHR.nimageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR resolveMode(@NativeType(value="VkResolveModeFlagBits") int value) {
        VkRenderingAttachmentInfoKHR.nresolveMode(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR resolveImageView(@NativeType(value="VkImageView") long value) {
        VkRenderingAttachmentInfoKHR.nresolveImageView(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR resolveImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkRenderingAttachmentInfoKHR.nresolveImageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
        VkRenderingAttachmentInfoKHR.nloadOp(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
        VkRenderingAttachmentInfoKHR.nstoreOp(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR clearValue(VkClearValue value) {
        VkRenderingAttachmentInfoKHR.nclearValue(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR clearValue(Consumer<VkClearValue> consumer) {
        consumer.accept(this.clearValue());
        return this;
    }

    @Override
    public VkRenderingAttachmentInfoKHR set(int sType, long pNext, long imageView, int imageLayout, int resolveMode, long resolveImageView, int resolveImageLayout, int loadOp, int storeOp, VkClearValue clearValue) {
        this.sType(sType);
        this.pNext(pNext);
        this.imageView(imageView);
        this.imageLayout(imageLayout);
        this.resolveMode(resolveMode);
        this.resolveImageView(resolveImageView);
        this.resolveImageLayout(resolveImageLayout);
        this.loadOp(loadOp);
        this.storeOp(storeOp);
        this.clearValue(clearValue);
        return this;
    }

    public VkRenderingAttachmentInfoKHR set(VkRenderingAttachmentInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderingAttachmentInfoKHR malloc() {
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderingAttachmentInfoKHR calloc() {
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderingAttachmentInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderingAttachmentInfoKHR create(long address) {
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkRenderingAttachmentInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderingAttachmentInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingAttachmentInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRenderingAttachmentInfoKHR malloc(MemoryStack stack) {
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderingAttachmentInfoKHR calloc(MemoryStack stack) {
        return (VkRenderingAttachmentInfoKHR)VkRenderingAttachmentInfoKHR.wrap(VkRenderingAttachmentInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderingAttachmentInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkRenderingAttachmentInfo.Buffer {
        private static final VkRenderingAttachmentInfoKHR ELEMENT_FACTORY = VkRenderingAttachmentInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderingAttachmentInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingAttachmentInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000044001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingAttachmentInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkRenderingAttachmentInfoKHR.nimageView(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageLayout(@NativeType(value="VkImageLayout") int value) {
            VkRenderingAttachmentInfoKHR.nimageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer resolveMode(@NativeType(value="VkResolveModeFlagBits") int value) {
            VkRenderingAttachmentInfoKHR.nresolveMode(this.address(), value);
            return this;
        }

        @Override
        public Buffer resolveImageView(@NativeType(value="VkImageView") long value) {
            VkRenderingAttachmentInfoKHR.nresolveImageView(this.address(), value);
            return this;
        }

        @Override
        public Buffer resolveImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkRenderingAttachmentInfoKHR.nresolveImageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
            VkRenderingAttachmentInfoKHR.nloadOp(this.address(), value);
            return this;
        }

        @Override
        public Buffer storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
            VkRenderingAttachmentInfoKHR.nstoreOp(this.address(), value);
            return this;
        }

        @Override
        public Buffer clearValue(VkClearValue value) {
            VkRenderingAttachmentInfoKHR.nclearValue(this.address(), value);
            return this;
        }

        @Override
        public Buffer clearValue(Consumer<VkClearValue> consumer) {
            consumer.accept(this.clearValue());
            return this;
        }
    }
}

