/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.dbtree;

import ca.sqlpower.architect.swingui.SQLTypeTreeCellRenderer;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.architect.swingui.dbtree.IconFilter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.UserDefinedSQLTypeSnapshot;
import ca.sqlpower.swingui.ComposedIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class DBTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Logger logger = Logger.getLogger(DBTreeCellRenderer.class);
    public static final ImageIcon DB_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Database16.png"));
    public static final ImageIcon TARGET_DB_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Database_target16.png"));
    public static final ImageIcon CATALOG_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Catalog16.png"));
    public static final ImageIcon SCHEMA_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Schema16.png"));
    public static final ImageIcon TABLE_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Table16.png"));
    public static final ImageIcon EXPORTED_KEY_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/ExportedKey16.png"));
    public static final ImageIcon IMPORTED_KEY_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/ImportedKey16.png"));
    public static final ImageIcon OWNER_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Owner16.png"));
    public static final ImageIcon INDEX_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Index16.png"));
    public static final ImageIcon PK_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Index_key16.png"));
    public static final ImageIcon UNIQUE_INDEX_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Index_unique16.png"));
    public static final ImageIcon COLUMN_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("icons/Column16.png"));
    public static final ImageIcon ERROR_BADGE = new ImageIcon(DBTreeCellRenderer.class.getResource("/icons/parts/noAccess.png"));
    public static final ImageIcon REFRESH_ICON = new ImageIcon(DBTreeCellRenderer.class.getResource("/icons/arrow_refresh16.png"));
    private final List<IconFilter> iconFilterChain = new ArrayList<IconFilter>();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(value.toString());
        this.setToolTipText(this.getText());
        if (value instanceof SQLDatabase) {
            SQLDatabase db = (SQLDatabase)value;
            if (db.isPlayPenDatabase()) {
                this.setIcon(TARGET_DB_ICON);
            } else {
                this.setIcon(DB_ICON);
            }
        } else if (value instanceof SQLCatalog) {
            if (((SQLCatalog)value).getNativeTerm().equals("owner")) {
                this.setIcon(OWNER_ICON);
            } else if (((SQLCatalog)value).getNativeTerm().equals("database")) {
                this.setIcon(DB_ICON);
            } else if (((SQLCatalog)value).getNativeTerm().equals("schema")) {
                this.setIcon(SCHEMA_ICON);
            } else {
                this.setIcon(CATALOG_ICON);
            }
        } else if (value instanceof SQLSchema) {
            if (((SQLSchema)value).getNativeTerm().equals("owner")) {
                this.setIcon(OWNER_ICON);
            } else {
                this.setIcon(SCHEMA_ICON);
            }
        } else if (value instanceof SQLTable) {
            this.setIcon(TABLE_ICON);
            SQLTable table = (SQLTable)value;
            if (table.getObjectType() != null) {
                this.setText(table.getName() + " (" + table.getObjectType() + ")");
            } else {
                this.setText(table.getName());
            }
        } else if (value instanceof SQLRelationship) {
            this.setIcon(EXPORTED_KEY_ICON);
        } else if (value instanceof SQLRelationship.SQLImportedKey) {
            this.setIcon(IMPORTED_KEY_ICON);
        } else if (value instanceof SQLIndex) {
            SQLIndex i = (SQLIndex)value;
            if (i.isPrimaryKeyIndex()) {
                this.setIcon(PK_ICON);
            } else if (i.isUnique()) {
                this.setIcon(UNIQUE_INDEX_ICON);
            } else {
                this.setIcon(INDEX_ICON);
            }
        } else if (value instanceof SQLColumn) {
            this.tagColumn((SQLColumn)value);
            this.setIcon(COLUMN_ICON);
        } else if (value instanceof SQLIndex.Column) {
            SQLIndex.Column col = (SQLIndex.Column)value;
            logger.debug((Object)("Column has properties " + col));
            if (col.getColumn() != null) {
                this.tagColumn(col.getColumn());
            }
            this.setIcon(COLUMN_ICON);
        } else if (value instanceof UserDefinedSQLTypeSnapshot) {
            UserDefinedSQLTypeSnapshot snapshot = (UserDefinedSQLTypeSnapshot)value;
            this.setText(snapshot.getSPObject().getName());
            if (!((UserDefinedSQLTypeSnapshot)value).isDomainSnapshot()) {
                this.setIcon(SQLTypeTreeCellRenderer.TYPE_ICON);
            } else {
                this.setIcon(SQLTypeTreeCellRenderer.DOMAIN_ICON);
            }
            if (snapshot.isDeleted()) {
                this.setIcon((Icon)ComposedIcon.getInstance((Icon[])new Icon[]{this.getIcon(), ERROR_BADGE}));
            } else if (snapshot.isObsolete()) {
                BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                Graphics2D g = bufferedImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(REFRESH_ICON.getImage(), 8, 8, 8, 8, new Color(0xFFFFFF, true), null);
                g.dispose();
                this.setIcon((Icon)ComposedIcon.getInstance((Icon[])new Icon[]{this.getIcon(), new ImageIcon(bufferedImage)}));
            }
        } else if (tree.getModel() instanceof DBTreeModel && value == ((DBTreeModel)tree.getModel()).getSnapshotContainer()) {
            this.setText("Types");
            this.setIcon(null);
        } else {
            this.setIcon(null);
        }
        if (value instanceof SQLObject && !((SQLObject)value).getChildrenInaccessibleReasons().isEmpty()) {
            logger.debug((Object)("Children are not accessible from the node " + ((SQLObject)value).getName()));
            if (this.getIcon() == null) {
                this.setIcon(ERROR_BADGE);
            } else {
                this.setIcon((Icon)ComposedIcon.getInstance((Icon[])new Icon[]{this.getIcon(), ERROR_BADGE}));
            }
            this.setToolTipText("Inaccessible: " + ((SQLObject)value).getChildrenInaccessibleReasons());
        }
        this.selected = sel;
        this.hasFocus = hasFocus;
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else if (value instanceof SQLObject) {
            if (((SQLObject)value).isPopulated()) {
                this.setForeground(this.getTextNonSelectionColor());
            } else {
                this.setForeground(Color.LIGHT_GRAY);
            }
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (value instanceof SPObject || value == null) {
            for (IconFilter filter : this.getIconFilterChain()) {
                this.setIcon(filter.filterIcon(this.getIcon(), (SPObject)value));
            }
        }
        return this;
    }

    private void tagColumn(SQLColumn col) {
        StringBuffer tag = new StringBuffer();
        StringBuffer fullTag = new StringBuffer();
        boolean isPK = col.isPrimaryKey();
        boolean isFK = col.isForeignKey();
        boolean isAK = col.isUniqueIndexed() && !isPK;
        boolean emptyTag = true;
        if (isPK) {
            tag.append("P");
            emptyTag = false;
        }
        if (isFK) {
            tag.append("F");
            emptyTag = false;
        }
        if (isAK) {
            tag.append("A");
            emptyTag = false;
        }
        if (!emptyTag) {
            tag.append("K");
            fullTag.append("  [ ");
            fullTag.append(tag);
            fullTag.append(" ]");
            this.setText(this.getText() + fullTag.toString());
        }
    }

    public void addIconFilter(IconFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Null icon filters not allowed");
        }
        this.iconFilterChain.add(filter);
    }

    public boolean removeIconFilter(IconFilter filter) {
        return this.iconFilterChain.remove(filter);
    }

    public List<IconFilter> getIconFilterChain() {
        return Collections.unmodifiableList(this.iconFilterChain);
    }
}

