/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.config.ConfigHandler;
import org.keycloak.client.cli.config.ConfigUpdateOperation;
import org.keycloak.client.cli.config.InMemoryConfigHandler;
import org.keycloak.client.cli.config.RealmConfigData;
import org.keycloak.representations.AccessTokenResponse;

public class ConfigUtil {
    public static final String DEFAULT_CLIENT = "admin-cli";
    private static ConfigHandler handler;

    public static ConfigHandler getHandler() {
        return handler;
    }

    public static void setHandler(ConfigHandler handler) {
        ConfigUtil.handler = handler;
    }

    public static String getRegistrationToken(RealmConfigData data, String clientId) {
        String token = data.getClients().get(clientId);
        return token == null || token.length() == 0 ? null : token;
    }

    public static void setRegistrationToken(RealmConfigData data, String clientId, String token) {
        data.getClients().put(clientId, token == null ? "" : token);
    }

    public static void saveTokens(AccessTokenResponse tokens, String endpoint, String realm, String clientId, String signKey, Long sigExpiresAt, String secret, String grantTypeForAuthentication) {
        handler.saveMergeConfig(config -> {
            config.setServerUrl(endpoint);
            config.setRealm(realm);
            RealmConfigData realmConfig = config.ensureRealmConfigData(endpoint, realm);
            realmConfig.setToken(tokens.getToken());
            realmConfig.setRefreshToken(tokens.getRefreshToken());
            realmConfig.setSigningToken(signKey);
            realmConfig.setSecret(secret);
            realmConfig.setExpiresAt(System.currentTimeMillis() + tokens.getExpiresIn() * 1000L);
            if (realmConfig.getRefreshToken() != null) {
                realmConfig.setRefreshExpiresAt(tokens.getRefreshExpiresIn() == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + tokens.getRefreshExpiresIn() * 1000L);
            }
            realmConfig.setSigExpiresAt(sigExpiresAt);
            realmConfig.setClientId(clientId);
            realmConfig.setGrantTypeForAuthentication(grantTypeForAuthentication);
        });
    }

    public static void checkServerInfo(ConfigData config, String cmd) {
        if (config.getServerUrl() == null) {
            throw new RuntimeException("No server specified. Use --server, or '" + cmd + " config credentials'.");
        }
        if (config.getRealm() == null && config.getExternalToken() == null) {
            throw new RuntimeException("No realm or token specified. Use --realm, --token, or '" + cmd + " config credentials'.");
        }
    }

    public static boolean credentialsAvailable(ConfigData config) {
        boolean credsAvailable = config.getServerUrl() != null && (config.getExternalToken() != null || config.getRealm() != null && config.sessionRealmConfigData() != null && (config.sessionRealmConfigData().getRefreshToken() != null || config.sessionRealmConfigData().getToken() != null && "client_credentials".equals(config.sessionRealmConfigData().getGrantTypeForAuthentication())));
        return credsAvailable;
    }

    public static ConfigData loadConfig() {
        if (handler == null) {
            throw new RuntimeException("No ConfigHandler set");
        }
        return handler.loadConfig();
    }

    public static void saveMergeConfig(ConfigUpdateOperation op) {
        if (handler == null) {
            throw new RuntimeException("No ConfigHandler set");
        }
        handler.saveMergeConfig(op);
    }

    public static void setupInMemoryHandler(ConfigData config) {
        InMemoryConfigHandler memhandler = null;
        if (handler instanceof InMemoryConfigHandler) {
            memhandler = (InMemoryConfigHandler)handler;
        } else {
            memhandler = new InMemoryConfigHandler();
            handler = memhandler;
        }
        memhandler.setConfigData(config);
    }

    public static String getEffectiveClientId(ConfigData config) {
        String clientId = DEFAULT_CLIENT;
        RealmConfigData realmData = config.sessionRealmConfigData();
        if (realmData != null && realmData.getClientId() != null) {
            clientId = realmData.getClientId();
        }
        return clientId;
    }
}

