/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

class WeakIdentityHashMap<K, V> {
    private Map<WeakReference<K>, V> map = Util.newMap();
    private ReferenceQueue<K> refQueue = new ReferenceQueue();

    private WeakIdentityHashMap() {
    }

    static <K, V> WeakIdentityHashMap<K, V> make() {
        return new WeakIdentityHashMap<K, V>();
    }

    V get(K k) {
        this.expunge();
        WeakReference<K> weakReference = this.makeReference(k);
        return this.map.get(weakReference);
    }

    public V put(K k, V v) {
        this.expunge();
        if (k == null) {
            throw new IllegalArgumentException("Null key");
        }
        WeakReference<K> weakReference = this.makeReference(k, this.refQueue);
        return this.map.put(weakReference, v);
    }

    public V remove(K k) {
        this.expunge();
        WeakReference<K> weakReference = this.makeReference(k);
        return this.map.remove(weakReference);
    }

    private void expunge() {
        Reference<K> reference;
        while ((reference = this.refQueue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    private WeakReference<K> makeReference(K k) {
        return new IdentityWeakReference<K>(k);
    }

    private WeakReference<K> makeReference(K k, ReferenceQueue<K> referenceQueue) {
        return new IdentityWeakReference<K>(k, referenceQueue);
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        IdentityWeakReference(T t) {
            this(t, (ReferenceQueue<T>)null);
        }

        IdentityWeakReference(T t, ReferenceQueue<T> referenceQueue) {
            super(t, referenceQueue);
            this.hashCode = t == null ? 0 : System.identityHashCode(t);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWeakReference)) {
                return false;
            }
            IdentityWeakReference identityWeakReference = (IdentityWeakReference)object;
            Object t = this.get();
            return t != null && t == identityWeakReference.get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

