/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class Minifinder2ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATA = 1;
    public static final int MSG_CONFIGURATION = 2;
    public static final int MSG_SERVICES = 3;
    public static final int MSG_SYSTEM_CONTROL = 4;
    public static final int MSG_FIRMWARE = 126;
    public static final int MSG_RESPONSE = 127;

    public Minifinder2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(long code) {
        if (BitUtil.check(code, 0)) {
            return "lowBattery";
        }
        if (BitUtil.check(code, 1)) {
            return "overspeed";
        }
        if (BitUtil.check(code, 2)) {
            return "fallDown";
        }
        if (BitUtil.check(code, 8)) {
            return "powerOff";
        }
        if (BitUtil.check(code, 9)) {
            return "powerOn";
        }
        if (BitUtil.check(code, 12)) {
            return "sos";
        }
        return null;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int index, int type, ByteBuf buf) {
        if (channel != null) {
            ByteBuf body = Unpooled.buffer();
            if (type == 3) {
                while (buf.isReadable()) {
                    int endIndex = buf.readUnsignedByte() + buf.readerIndex();
                    short key = buf.readUnsignedByte();
                    switch (key) {
                        case 17: 
                        case 33: 
                        case 34: {
                            body.writeByte(10);
                            body.writeByte((int)key);
                            body.writeIntLE(0);
                            body.writeIntLE(0);
                            body.writeByte(0);
                            break;
                        }
                        case 18: {
                            body.writeByte(5);
                            body.writeByte((int)key);
                            body.writeIntLE((int)(System.currentTimeMillis() / 1000L));
                            break;
                        }
                    }
                    buf.readerIndex(endIndex);
                }
            } else {
                body.writeByte(1);
                body.writeByte(0);
            }
            ByteBuf content = Unpooled.buffer();
            content.writeByte(type == 3 ? type : 127);
            content.writeBytes(body);
            body.release();
            ByteBuf response = Unpooled.buffer();
            response.writeByte(171);
            response.writeByte(0);
            response.writeShortLE(content.readableBytes());
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, content.nioBuffer()));
            response.writeShortLE(index);
            response.writeBytes(content);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private String readTagId(ByteBuf buf) {
        StringBuilder tagId = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            tagId.insert(0, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(1)));
        }
        return tagId.toString();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int index = buf.readUnsignedShortLE();
        short type = buf.readUnsignedByte();
        if (BitUtil.check(flags, 4)) {
            this.sendResponse(channel, remoteAddress, index, type, buf.slice());
        }
        if (type == 1 || type == 3) {
            LinkedList<Position> positions = new LinkedList<Position>();
            HashSet<Integer> keys = new HashSet<Integer>();
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = null;
            while (buf.isReadable()) {
                int endIndex = buf.readUnsignedByte() + buf.readerIndex();
                short key = buf.readUnsignedByte();
                if (keys.contains(key)) {
                    positions.add(position);
                    keys.clear();
                    position = new Position(this.getProtocolName());
                }
                keys.add(Integer.valueOf(key));
                switch (key) {
                    case 1: {
                        deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readCharSequence(15, StandardCharsets.US_ASCII).toString());
                        if (deviceSession != null) break;
                        return null;
                    }
                    case 2: {
                        long alarm = buf.readUnsignedIntLE();
                        position.set("alarm", this.decodeAlarm(alarm));
                        if (!BitUtil.check(alarm, 31)) break;
                        position.set("bark", true);
                        break;
                    }
                    case 20: {
                        position.set("batteryLevel", buf.readUnsignedByte());
                        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                        break;
                    }
                    case 32: {
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                        position.setCourse(buf.readUnsignedShortLE());
                        position.setAltitude(buf.readShortLE());
                        int hdop = buf.readUnsignedShortLE();
                        position.setValid(hdop > 0);
                        position.set("hdop", (double)hdop * 0.1);
                        position.set("odometer", buf.readUnsignedIntLE());
                        position.set("sat", buf.readUnsignedByte());
                        break;
                    }
                    case 33: {
                        int mcc = buf.readUnsignedShortLE();
                        short mnc = buf.readUnsignedByte();
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            position.getNetwork().addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), rssi));
                        }
                        break;
                    }
                    case 34: {
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.getNetwork().addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), rssi));
                        }
                        break;
                    }
                    case 35: {
                        position.set("tagId", this.readTagId(buf));
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setValid(true);
                        break;
                    }
                    case 36: {
                        position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                        long status = buf.readUnsignedIntLE();
                        if (BitUtil.check(status, 4)) {
                            position.set("charge", true);
                        }
                        if (BitUtil.check(status, 7)) {
                            position.set("archive", true);
                        }
                        position.set("motion", BitUtil.check(status, 9));
                        position.set("rssi", BitUtil.between(status, 19, 24));
                        position.set("batteryLevel", BitUtil.from(status, 24));
                        position.set("status", status);
                        break;
                    }
                    case 40: {
                        short beaconFlags = buf.readUnsignedByte();
                        position.set("tagId", this.readTagId(buf));
                        position.set("tagRssi", Integer.valueOf(buf.readByte()));
                        position.set("tag1mRssi", Integer.valueOf(buf.readByte()));
                        if (BitUtil.check(beaconFlags, 7)) {
                            position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                            position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                            position.setValid(true);
                        }
                        if (!BitUtil.check(beaconFlags, 6)) break;
                        position.set("description", buf.readCharSequence(endIndex - buf.readerIndex(), StandardCharsets.US_ASCII).toString());
                        break;
                    }
                    case 42: {
                        buf.readUnsignedByte();
                        buf.skipBytes(6);
                        buf.readUnsignedByte();
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setValid(true);
                        break;
                    }
                    case 48: {
                        buf.readUnsignedIntLE();
                        position.set("steps", buf.readUnsignedIntLE());
                        break;
                    }
                    case 49: {
                        int i = 1;
                        while (buf.readerIndex() < endIndex) {
                            position.set("activity" + i + "Time", buf.readUnsignedIntLE());
                            position.set("activity" + i, buf.readUnsignedIntLE());
                            ++i;
                        }
                        break;
                    }
                    case 55: {
                        buf.readUnsignedIntLE();
                        long barking = buf.readUnsignedIntLE();
                        if (BitUtil.check(barking, 31)) {
                            position.set("barkStop", true);
                        }
                        position.set("barkCount", BitUtil.to(barking, 31));
                        break;
                    }
                    case 64: {
                        buf.readUnsignedIntLE();
                        short heartRate = buf.readUnsignedByte();
                        if (heartRate <= 1) break;
                        position.set("heartRate", Integer.valueOf(heartRate));
                        break;
                    }
                }
                buf.readerIndex(endIndex);
            }
            positions.add(position);
            if (deviceSession != null) {
                for (Position p : positions) {
                    p.setDeviceId(deviceSession.getDeviceId());
                    if (p.getValid() || p.hasAttribute("hdop")) continue;
                    this.getLastLocation(p, null);
                }
            } else {
                return null;
            }
            return positions;
        }
        if (type == 127) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            buf.readUnsignedByte();
            position.set("result", String.valueOf(buf.readUnsignedByte()));
            return position;
        }
        return null;
    }
}

