/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.tomcat.jakartaee.EESpecProfile;

public enum EESpecProfiles implements EESpecProfile
{
    TOMCAT("javax", "jakarta", "javax([/\\.](annotation[/\\.](" + Patterns.ANNOTATION_CLASSES + ")|ejb|el|mail|persistence|security[/\\.]auth[/\\.]message|servlet|transaction(?![/\\.]xa)|websocket))"),
    EE("javax", "jakarta", "javax" + Patterns.EE),
    JEE8("jakarta", "javax", "jakarta" + Patterns.EE);

    private String source;
    private String target;
    private Pattern pattern;

    private EESpecProfiles(String source, String target, String pattern) {
        this.source = source;
        this.target = target;
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    private static final class Patterns {
        static final String ANNOTATION_CLASSES = String.join((CharSequence)"|", Arrays.asList("Generated", "ManagedBean", "PostConstruct", "PreDestroy", "Priority", "Resource", "Resources", "security[/\\.]DeclareRoles", "security[/\\.]DenyAll", "security[/\\.]PermitAll", "security[/\\.]RolesAllowed", "security[/\\.]RunAs", "sql[/\\.]DataSourceDefinition"));
        static final String EE = String.join((CharSequence)"|", Arrays.asList("([/\\.](activation", "annotation[/\\.](" + ANNOTATION_CLASSES + ")", "batch", "decorator", "ejb", "el", "enterprise", "faces", "jms", "json", "jws", "interceptor", "inject", "mail", "management[/\\.]j2ee", "persistence", "resource", "security[/\\.](auth[/\\.]message|enterprise|jacc)", "servlet", "transaction(?![/\\.]xa)", "validation", "websocket", "ws[/\\.]rs", "xml[/\\.](bind|soap|ws)))"));

        private Patterns() {
        }
    }
}

