/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc
extends SystemFunctionCall
implements Callable {
    private String expressionBaseURI = null;
    private boolean readOnce = false;
    private ParseOptions parseOptions;

    public void setReadOnce(boolean once) {
        this.readOnce = once;
    }

    public boolean isReadOnce() {
        return this.readOnce;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setParseOptions(ParseOptions parseOptions) {
        this.parseOptions = parseOptions;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public void setBaseURI(String baseURI) {
        this.expressionBaseURI = baseURI;
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        Configuration config = visitor.getConfiguration();
        if (((Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/preEvaluateDocFunction")).booleanValue()) {
            try {
                AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(null);
                if (hrefVal == null) {
                    return null;
                }
                String href = hrefVal.getStringValue();
                if (href.indexOf(35) >= 0) {
                    return this;
                }
                NodeInfo item = DocumentFn.preLoadDoc(href, this.expressionBaseURI, config, this);
                if (item != null) {
                    return Literal.makeLiteral(new One<NodeInfo>(item), this.getContainer());
                }
            }
            catch (Exception err) {
                return this;
            }
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        return this.argument[0].getCardinality() & 0xFFFF7FFF;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public Expression copy() {
        Doc d = (Doc)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        d.readOnce = this.readOnce;
        if (this.parseOptions != null) {
            d.parseOptions = new ParseOptions(this.parseOptions);
        }
        return d;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Doc && super.equals(o) && Doc.equalOrNull(this.expressionBaseURI, ((Doc)o).expressionBaseURI) && this.readOnce == ((Doc)o).readOnce;
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        return this.doc(context);
    }

    @Override
    public ZeroOrOne<NodeInfo> call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)arguments[0].head();
        if (hrefVal == null) {
            return ZeroOrOne.empty();
        }
        String href = hrefVal.getStringValue();
        NodeInfo item = DocumentFn.makeDoc(href, this.expressionBaseURI, context, this, false);
        if (item == null) {
            this.dynamicError("Failed to load document " + href, "FODC0002", context);
            return null;
        }
        return new ZeroOrOne<NodeInfo>(item);
    }

    @Override
    public int computeSpecialProperties() {
        return 0xCA0000;
    }

    private NodeInfo doc(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return null;
        }
        String href = hrefVal.getStringValue();
        NodeInfo item = DocumentFn.makeDoc(href, this.expressionBaseURI, context, this, false);
        if (item == null) {
            this.dynamicError("Failed to load document " + href, "FODC0002", context);
            return null;
        }
        return item;
    }

    public void sendDocument(XPathContext context, Receiver out) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return;
        }
        String href = hrefVal.getStringValue();
        ParseOptions options = this.parseOptions;
        if (options == null) {
            options = context.getConfiguration().getParseOptions();
        }
        try {
            DocumentFn.sendDoc(href, this.expressionBaseURI, context, this, out, options);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            if (e.getErrorCodeQName() == null) {
                e.setErrorCode("FODC0002");
            }
            throw e;
        }
    }
}

