/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Opaque,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String CLASS_NAME = OpaqueDescriptor.class.getName();

    public OpaqueDescriptor(String name, Connection conn) throws SQLException {
        this(name, conn, true);
    }

    private OpaqueDescriptor(String name, Connection conn, boolean constructInitialized) throws SQLException {
        super((short)58, name, conn);
        if (constructInitialized) {
            this.initPickler();
        }
    }

    public OpaqueDescriptor(SQLName name, Connection conn) throws SQLException {
        super((short)58, name, conn);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName name, OracleTypeOPAQUE type, Connection conn) throws SQLException {
        super((short)58, name, type, conn);
    }

    public OpaqueDescriptor(OracleTypeADT type, Connection conn) throws SQLException {
        super((short)58, type, conn);
    }

    OpaqueDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)108);
        this.toid = _toid;
        this.toidVersion = _toidVersion;
        this.setPhysicalConnectionOf(conn);
        this.initPickler();
    }

    public static OpaqueDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        if (name == null || name.length() == 0) {
            throw (SQLException)DatabaseError.createSqlException(60, "Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null").fillInStackTrace();
        }
        SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
        String qualifiedName = sqlName.getName();
        OpaqueDescriptor descriptor = null;
        if (conn != null) {
            descriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName);
        }
        if (descriptor == null) {
            if (qualifiedName.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, qualifiedName, 7L);
                descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
            } else if (qualifiedName.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, qualifiedName, 7L);
                descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
            } else {
                short dbVersion = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getVersionNumber();
                descriptor = dbVersion >= 12000 ? new OpaqueDescriptor(name, conn) : new OpaqueDescriptor(sqlName, conn);
            }
            if (conn != null) {
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
            }
        }
        return descriptor;
    }

    public static CompletionStage<OpaqueDescriptor> createDescriptorAsync(String name, Connection conn) {
        if (name == null || name.length() == 0) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null").fillInStackTrace());
        }
        try {
            CompletionStage<OpaqueDescriptor> descriptorStage;
            OpaqueDescriptor cachedDescriptor;
            OracleConnection ojiConn = (OracleConnection)conn;
            SQLName sqlName = new SQLName(name, ojiConn);
            String qualifiedName = sqlName.getName();
            if (ojiConn != null && (cachedDescriptor = (OpaqueDescriptor)ojiConn.getDescriptor(qualifiedName)) != null) {
                return CompletableFuture.completedStage(cachedDescriptor);
            }
            if (qualifiedName.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, qualifiedName, 7L);
                descriptorStage = CompletableFuture.completedStage(new OpaqueDescriptor(sqlName, pickler, (Connection)ojiConn));
            } else if (qualifiedName.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, qualifiedName, 7L);
                descriptorStage = CompletableFuture.completedStage(new OpaqueDescriptor(sqlName, pickler, conn));
            } else {
                OpaqueDescriptor descriptor2 = new OpaqueDescriptor(name, conn, false);
                descriptorStage = descriptor2.initPicklerAsync().thenApply(nil -> descriptor2);
            }
            if (ojiConn != null) {
                return descriptorStage.thenApply(CompletionStageUtil.normalCompletionHandler(descriptor -> {
                    ojiConn.putDescriptor(qualifiedName, descriptor);
                    return descriptor;
                }));
            }
            return descriptorStage;
        }
        catch (SQLException createDescriptorException) {
            return CompletableFuture.failedStage(createDescriptorException);
        }
    }

    public static OpaqueDescriptor createDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        String qualifiedName = sqlName.getName();
        OpaqueDescriptor descriptor = null;
        if (conn != null) {
            descriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName);
        }
        if (descriptor == null) {
            if (qualifiedName.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, qualifiedName, 7L);
                descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
            } else if (qualifiedName.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE pickler = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, qualifiedName, 7L);
                descriptor = new OpaqueDescriptor(sqlName, pickler, conn);
            } else {
                descriptor = new OpaqueDescriptor(sqlName, conn);
            }
            if (conn != null) {
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
            }
        }
        return descriptor;
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.OPAQUE;
    }

    private void initPickler() throws SQLException {
        try {
            String typeName = this.typeNameByUser;
            if (typeName == null) {
                typeName = this.getName();
            }
            this.pickler = new OracleTypeADT(typeName, (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (SQLException sqlException) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initPickler", "exception caught and thrown : {0} ", (String)null, sqlException, (Object)sqlException.getMessage());
            throw sqlException;
        }
        catch (Exception e) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initPickler", "exception caught and thrown : {0} ", (String)null, e, (Object)e.getMessage());
            throw (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private CompletionStage<Void> initPicklerAsync() {
        CompletionStage<Object> initializationStage;
        try {
            String typeName = this.typeNameByUser;
            if (typeName == null) {
                typeName = this.getName();
            }
            this.pickler = new OracleTypeADT(typeName, (Connection)this.connection);
            initializationStage = ((OracleTypeADT)this.pickler).initAsync(this.connection).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
                this.pickler.setDescriptor(this);
                return nil;
            }));
        }
        catch (Exception e) {
            initializationStage = CompletableFuture.failedStage(e);
        }
        return initializationStage.exceptionally(completionError -> {
            SQLException thrownException;
            Throwable error = CompletionStageUtil.unwrapCompletionException(completionError);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initPicklerAsync", "exception caught and thrown : {0} ", (String)null, error, (Object)error.getMessage());
            if (error instanceof SQLException) {
                thrownException = (SQLException)error;
            } else {
                try {
                    thrownException = (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
                }
                catch (SQLException getNameException) {
                    throw new CompletionException(getNameException);
                }
            }
            throw new CompletionException(thrownException);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        byte[] ret = null;
        if (obj.shareBytes() != null) {
            ret = obj.shareBytes();
        } else {
            try {
                ret = this.pickler.linearize(obj);
            }
            finally {
                if (!keepLocalCopy) {
                    obj.setShareBytes(null);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        byte[] ret = null;
        if (obj.value != null) {
            ret = obj.value;
        } else {
            try {
                this.pickler.unlinearize(obj.shareBytes(), 0L, obj, 1, null);
                ret = obj.value;
            }
            finally {
                if (!keepLocalCopy) {
                    obj.value = null;
                }
            }
        }
        return ret;
    }

    @Override
    public int getTypeCode() throws SQLException {
        if (this.sqlName != null && "SYS.XMLTYPE".equalsIgnoreCase(this.sqlName.getName()) || this.typeNameByUser != null && "SYS.XMLTYPE".equals(this.typeNameByUser)) {
            return 2009;
        }
        return 2007;
    }

    @Override
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        OpaqueDescriptor currentDescriptor = this;
        String currentName = currentDescriptor.getName();
        return checkThisName.equals(currentName);
    }

    @Override
    public long getMaxLength() throws SQLException {
        long ret = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
        return ret;
    }

    @Override
    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
    }

    @Override
    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isModeledInC();
    }

    @Override
    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
    }

    @Override
    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        StringBuffer strBuf = new StringBuffer();
        return this.descType(strBuf, 0);
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        Object level_one = "";
        for (int i = 0; i < level; ++i) {
            level_one = (String)level_one + "  ";
        }
        String level_two = (String)level_one + "  ";
        strBuf.append((String)level_one);
        strBuf.append(this.getTypeName());
        strBuf.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        strBuf.append("\n");
        return strBuf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeObject", "does nothing", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readObject", "does nothing", null, null);
    }
}

