/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.locking;

import java.time.Duration;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.locking.GlobalLockProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class NoneGlobalLockProviderFactory
implements GlobalLockProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "none";

    public GlobalLockProvider create(final KeycloakSession session) {
        return new GlobalLockProvider(){

            public void close() {
            }

            @Override
            public <V> V withLock(String lockName, Duration timeToWaitForLock, KeycloakSessionTaskWithResult<V> task) {
                return KeycloakModelUtils.runJobInTransactionWithResult(session.getKeycloakSessionFactory(), task);
            }

            @Override
            public void forceReleaseAllLocks() {
            }
        };
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

