/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;

final class QuarkusPersistenceXmlParser
extends PersistenceXmlParser {
    public static List<ParsedPersistenceXmlDescriptor> locatePersistenceUnits() {
        QuarkusPersistenceXmlParser parser = new QuarkusPersistenceXmlParser();
        parser.doResolve();
        return parser.getResolvedPersistenceUnits();
    }

    private QuarkusPersistenceXmlParser() {
        super(FlatClassLoaderService.INSTANCE, PersistenceUnitTransactionType.RESOURCE_LOCAL);
    }

    private void doResolve() {
        List xmlUrls = FlatClassLoaderService.INSTANCE.locateResources("META-INF/persistence.xml");
        for (URL xmlUrl : xmlUrls) {
            this.parsePersistenceXml(xmlUrl, Collections.emptyMap());
        }
    }
}

