/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IpSelector
extends AbstractPacket {
    private static final long serialVersionUID = -1L;

    public static Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        int ipVersion = rawData[offset] >> 4 & 0xF;
        PacketFactory<Packet, EtherType> factory = PacketFactories.getFactory(Packet.class, EtherType.class);
        if (ipVersion == ((Byte)IpVersion.IPV4.value()).intValue()) {
            return factory.newInstance(rawData, offset, length, EtherType.IPV4);
        }
        if (ipVersion == ((Byte)IpVersion.IPV6.value()).intValue()) {
            return factory.newInstance(rawData, offset, length, EtherType.IPV6);
        }
        return PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset, length, NotApplicable.UNKNOWN);
    }

    private IpSelector() {
        throw new AssertionError();
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }
}

