/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpByePacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSdesPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.RtcpXrPacket;
import org.jitsi.rtp.rtcp.rtcpfb.UnsupportedRtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.RtcpFbNackPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RtcpTermination;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numFailedToForward", "", "packetReceiveCounts", "", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "trace", "", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public final class RtcpTermination
extends TransformerNode {
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final Logger logger;
    @NotNull
    private Map<String, Integer> packetReceiveCounts;
    private int numFailedToForward;

    public RtcpTermination(@NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RTCP termination");
        this.rtcpEventNotifier = rtcpEventNotifier2;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.packetReceiveCounts = new LinkedHashMap();
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        PacketInfo packetInfo2;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        CompoundRtcpPacket compoundRtcp = (CompoundRtcpPacket)packetInfo.packetAs();
        RtcpPacket forwardedRtcp = null;
        Iterable $this$forEach$iv = compoundRtcp.getPackets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtcpSrPacket it;
            RtcpPacket rtcpPacket = (RtcpPacket)element$iv;
            boolean bl = false;
            RtcpPacket rtcpPacket2 = rtcpPacket;
            if ((rtcpPacket2 instanceof RtcpFbPliPacket ? true : rtcpPacket2 instanceof RtcpFbFirPacket) ? true : rtcpPacket2 instanceof RtcpSrPacket) {
                if (forwardedRtcp != null) {
                    boolean bl2 = false;
                    Logger $this$cinfo$iv22 = this.logger;
                    boolean $i$f$cinfo = false;
                    if ($this$cinfo$iv22.isInfoEnabled()) {
                        RtcpPacket it2;
                        Logger logger = $this$cinfo$iv22;
                        boolean bl3 = false;
                        logger.info("Failed to forward a packet of type " + Reflection.getOrCreateKotlinClass(it2.getClass()).getSimpleName() + " . Replaced by " + Reflection.getOrCreateKotlinClass(rtcpPacket.getClass()).getSimpleName() + ".");
                    }
                    int $this$cinfo$iv22 = this.numFailedToForward;
                    this.numFailedToForward = $this$cinfo$iv22 + 1;
                }
                forwardedRtcp = rtcpPacket;
            } else if (!(((((rtcpPacket2 instanceof RtcpSdesPacket ? true : rtcpPacket2 instanceof RtcpRrPacket) ? true : rtcpPacket2 instanceof RtcpFbNackPacket) ? true : rtcpPacket2 instanceof RtcpByePacket) ? true : rtcpPacket2 instanceof RtcpFbTccPacket) ? true : rtcpPacket2 instanceof RtcpFbRembPacket) && !(rtcpPacket2 instanceof RtcpXrPacket)) {
                Logger logger;
                Logger $this$cinfo$iv;
                if (rtcpPacket2 instanceof UnsupportedRtcpFbPacket) {
                    $this$cinfo$iv = this.logger;
                    boolean $i$f$cinfo = false;
                    if ($this$cinfo$iv.isInfoEnabled()) {
                        logger = $this$cinfo$iv;
                        boolean bl4 = false;
                        logger.info("TODO: not yet handling RTCP packet of type " + rtcpPacket.getPacketType() + " fmt " + rtcpPacket.getReportCount() + " " + rtcpPacket.getClass());
                    }
                } else {
                    $this$cinfo$iv = this.logger;
                    boolean $i$f$cinfo = false;
                    if ($this$cinfo$iv.isInfoEnabled()) {
                        logger = $this$cinfo$iv;
                        boolean bl5 = false;
                        logger.info("TODO: not yet handling RTCP packet of type " + rtcpPacket.getPacketType() + " " + rtcpPacket.getClass());
                    }
                }
            }
            String string = Reflection.getOrCreateKotlinClass(rtcpPacket.getClass()).getSimpleName();
            Intrinsics.checkNotNull(string);
            this.packetReceiveCounts.merge(string, 1, (n, p1$other) -> n + p1$other);
            RtcpEventNotifier.notifyRtcpReceived$default(this.rtcpEventNotifier, rtcpPacket, packetInfo.getReceivedTime(), false, 4, null);
            RtcpPacket rtcpPacket3 = forwardedRtcp;
            if ((rtcpPacket3 instanceof RtcpSrPacket ? (RtcpSrPacket)rtcpPacket3 : null) == null) continue;
            it = it;
            boolean bl6 = false;
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl7 = false;
                logger.debug("Saw an sr from ssrc=" + rtcpPacket.getSenderSsrc() + ", timestamp=" + it.getSenderInfo().getRtpTimestamp());
            }
            forwardedRtcp = it.getReportCount() > 0 ? (RtcpPacket)it.cloneWithoutReportBlocks() : (RtcpPacket)it;
        }
        RtcpPacket rtcpPacket = forwardedRtcp;
        if (rtcpPacket != null) {
            RtcpPacket it = rtcpPacket;
            boolean bl = false;
            if (it.buffer != packetInfo.getPacket().buffer) {
                Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
                Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
                function1.invoke(packetInfo.getPacket().buffer);
            }
            packetInfo.setPacket(it);
            packetInfo2 = packetInfo;
        } else {
            RtcpTermination $this$transform_u24lambda_u2d8 = this;
            boolean bl = false;
            packetInfo2 = null;
        }
        return packetInfo2;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d10 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        Map<String, Integer> $this$forEach$iv = this.packetReceiveCounts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Integer> element$iv;
            Map.Entry<String, Integer> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String type2 = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            $this$getNodeStats_u24lambda_u2d10.addNumber("num_" + type2 + "_rx", count);
        }
        $this$getNodeStats_u24lambda_u2d10.addNumber("num_failed_to_forward", this.numFailedToForward);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

