/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;

public class UpgradeProtocolHandler
implements ProtocolHandler {
    private final List<String> protocols = List.of("websocket", "h2c");

    @Override
    public String getName() {
        return "upgrade";
    }

    @Override
    public boolean accept(Request request, Response response2) {
        boolean upgraded = 101 == response2.getStatus();
        boolean accepted = false;
        if (upgraded) {
            accepted = this.acceptHeaders(request, response2);
        }
        return upgraded && accepted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean acceptHeaders(Request request, Response response2) {
        HttpField requestUpgrade;
        HttpField responseUpgrade = response2.getHeaders().getField(HttpHeader.UPGRADE);
        if (responseUpgrade != null) {
            if (this.protocols.stream().anyMatch(responseUpgrade::contains)) {
                return true;
            }
        }
        if ((requestUpgrade = request.getHeaders().getField(HttpHeader.UPGRADE)) == null) return false;
        if (!this.protocols.stream().anyMatch(requestUpgrade::contains)) return false;
        return true;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new Response.Listener.Adapter(){

            @Override
            public void onComplete(Result result2) {
                HttpResponse response2 = (HttpResponse)result2.getResponse();
                HttpRequest request = (HttpRequest)response2.getRequest();
                if (result2.isSucceeded()) {
                    try {
                        HttpConversation conversation = request.getConversation();
                        HttpUpgrader upgrader = (HttpUpgrader)conversation.getAttribute(HttpUpgrader.class.getName());
                        if (upgrader == null) {
                            throw new HttpResponseException("101 response without " + HttpUpgrader.class.getSimpleName(), response2);
                        }
                        EndPoint endPoint = (EndPoint)conversation.getAttribute(EndPoint.class.getName());
                        if (endPoint == null) {
                            throw new HttpResponseException("Upgrade without " + EndPoint.class.getSimpleName(), response2);
                        }
                        upgrader.upgrade(response2, endPoint, Callback.from(Callback.NOOP::succeeded, x -> UpgradeProtocolHandler.this.forwardFailureComplete(request, null, response2, (Throwable)x)));
                    }
                    catch (Throwable x2) {
                        UpgradeProtocolHandler.this.forwardFailureComplete(request, null, response2, x2);
                    }
                } else {
                    UpgradeProtocolHandler.this.forwardFailureComplete(request, result2.getRequestFailure(), response2, result2.getResponseFailure());
                }
            }
        };
    }

    private void forwardFailureComplete(HttpRequest request, Throwable requestFailure, Response response2, Throwable responseFailure) {
        HttpConversation conversation = request.getConversation();
        conversation.updateResponseListeners(null);
        List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
        ResponseNotifier notifier = new ResponseNotifier();
        notifier.forwardFailure(responseListeners, response2, responseFailure);
        notifier.notifyComplete(responseListeners, new Result(request, requestFailure, response2, responseFailure));
    }
}

