/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import java.util.Arrays;

public class StackState {
    private int pos = -1;
    private final SVType[] stack;

    public StackState(int maxStack) {
        this.stack = new SVType[maxStack];
    }

    private StackState(int pos, SVType[] stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public StackState copy() {
        return new StackState(this.pos, Arrays.copyOf(this.stack, this.stack.length));
    }

    public int peek() {
        return this.pos;
    }

    public int peekAt(int at) {
        return this.pos - at;
    }

    public SVType peekTypeAt(int at) {
        int p = this.pos - at;
        if (this.checkStackIndex(p)) {
            return this.stack[p];
        }
        return SVType.NARROW;
    }

    public int push(SVType type) {
        int p;
        if (this.checkStackIndex(p = ++this.pos)) {
            this.stack[p] = type;
        }
        return p;
    }

    private boolean checkStackIndex(int p) {
        return p >= 0 && p < this.stack.length;
    }

    public int pop() {
        return this.pos--;
    }

    public void clear() {
        this.pos = -1;
    }

    public String toString() {
        int size = this.pos + 1;
        String arr = size == 0 ? "empty" : (size > 0 && size < this.stack.length ? Arrays.toString((Object[])Arrays.copyOf(this.stack, size)) : Arrays.toString((Object[])this.stack) + " (max)");
        return "Stack: " + size + ": " + arr;
    }

    public static enum SVType {
        NARROW,
        WIDE;

    }
}

