/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.util.Node;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.ResourceFilter;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterAppliesTo;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterMatcher;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterType;
import org.gradle.plugins.ide.eclipse.model.internal.DefaultResourceFilter;
import org.gradle.plugins.ide.eclipse.model.internal.DefaultResourceFilterMatcher;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class Project
extends XmlPersistableConfigurationObject {
    public static final String PROJECT_FILE_NAME = ".project";
    private String name;
    private String comment;
    private Set<String> referencedProjects = Sets.newLinkedHashSet();
    private List<String> natures = Lists.newArrayList();
    private List<BuildCommand> buildCommands = Lists.newArrayList();
    private Set<Link> linkedResources = Sets.newLinkedHashSet();
    private Set<ResourceFilter> resourceFilters = Sets.newLinkedHashSet();

    public Project(XmlTransformer xmlTransformer) {
        super(xmlTransformer);
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultProject.xml";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Set<String> getReferencedProjects() {
        return this.referencedProjects;
    }

    public void setReferencedProjects(Set<String> referencedProjects) {
        this.referencedProjects = referencedProjects;
    }

    public List<String> getNatures() {
        return this.natures;
    }

    public void setNatures(List<String> natures) {
        this.natures = natures;
    }

    public List<BuildCommand> getBuildCommands() {
        return this.buildCommands;
    }

    public void setBuildCommands(List<BuildCommand> buildCommands) {
        this.buildCommands = buildCommands;
    }

    public Set<Link> getLinkedResources() {
        return this.linkedResources;
    }

    public void setLinkedResources(Set<Link> linkedResources) {
        this.linkedResources = linkedResources;
    }

    public Set<ResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public void setResourceFilters(Set<ResourceFilter> resourceFilters) {
        this.resourceFilters = resourceFilters;
    }

    public Object configure(EclipseProject eclipseProject) {
        this.name = Strings.nullToEmpty((String)eclipseProject.getName());
        this.comment = Strings.nullToEmpty((String)eclipseProject.getComment());
        this.referencedProjects.addAll(eclipseProject.getReferencedProjects());
        this.natures.addAll(eclipseProject.getNatures());
        this.natures = Lists.newArrayList((Iterable)Sets.newLinkedHashSet(this.natures));
        this.buildCommands.addAll(eclipseProject.getBuildCommands());
        this.buildCommands = Lists.newArrayList((Iterable)Sets.newLinkedHashSet(this.buildCommands));
        this.resourceFilters.addAll(eclipseProject.getResourceFilters());
        return this.linkedResources.addAll(eclipseProject.getLinkedResources());
    }

    @Override
    protected void load(Node xml) {
        Node nameNode = Project.findFirstChildNamed(xml, "name");
        this.name = nameNode != null ? nameNode.text() : "";
        Node commentNode = Project.findFirstChildNamed(xml, "comment");
        this.comment = commentNode != null ? commentNode.text() : "";
        this.readReferencedProjects();
        this.readNatures();
        this.readBuildCommands();
        this.readLinkedResources();
        this.readResourceFilters();
    }

    private void readReferencedProjects() {
        for (Node projectNode : Project.getChildren(Project.findFirstChildNamed(this.getXml(), "projects"), "project")) {
            this.referencedProjects.add(projectNode.text());
        }
    }

    private void readNatures() {
        for (Node natureNode : Project.getChildren(Project.findFirstChildNamed(this.getXml(), "natures"), "nature")) {
            this.natures.add(natureNode.text());
        }
    }

    private void readBuildCommands() {
        for (Node commandNode : Project.getChildren(Project.findFirstChildNamed(this.getXml(), "buildSpec"), "buildCommand")) {
            String name = Project.findFirstChildNamed(commandNode, "name").text();
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            for (Node dictionaryNode : Project.getChildren(Project.findFirstChildNamed(commandNode, "arguments"), "dictionary")) {
                String key = Project.findFirstChildNamed(dictionaryNode, "key").text();
                String value = Project.findFirstChildNamed(dictionaryNode, "value").text();
                arguments.put(key, value);
            }
            this.buildCommands.add(new BuildCommand(name, arguments));
        }
    }

    private void readLinkedResources() {
        for (Node linkNode : Project.getChildren(Project.findFirstChildNamed(this.getXml(), "linkedResources"), "link")) {
            Node nameNode = Project.findFirstChildNamed(linkNode, "name");
            Node typeNode = Project.findFirstChildNamed(linkNode, "type");
            Node locationNode = Project.findFirstChildNamed(linkNode, "location");
            Node locationUriNode = Project.findFirstChildNamed(linkNode, "locationURI");
            this.linkedResources.add(new Link(nameNode != null ? nameNode.text() : null, typeNode != null ? typeNode.text() : null, locationNode != null ? locationNode.text() : null, locationUriNode != null ? locationUriNode.text() : null));
        }
    }

    private void readResourceFilters() {
        for (Node filterNode : Project.getChildren(Project.findFirstChildNamed(this.getXml(), "filteredResources"), "filter")) {
            Node typeNode = Project.findFirstChildNamed(filterNode, "type");
            Node matcherNode = Project.findFirstChildNamed(filterNode, "matcher");
            String typeString = typeNode != null ? typeNode.text() : null;
            int typeBitmask = Integer.parseInt(typeString);
            ResourceFilterAppliesTo appliesTo = this.resourceFilterTypeBitmaskToAppliesTo(typeBitmask);
            ResourceFilterType type = this.resourceFilterTypeBitmaskToType(typeBitmask);
            boolean recursive = this.isResourceFilterTypeBitmaskRecursive(typeBitmask);
            ResourceFilterMatcher matcher = this.readResourceFilterMatcher(matcherNode);
            this.resourceFilters.add(new DefaultResourceFilter(appliesTo, type, recursive, matcher));
        }
    }

    @Override
    protected void store(Node xml) {
        for (String childNodeName : Arrays.asList("name", "comment", "projects", "natures", "buildSpec", "linkedResources", "filteredResources")) {
            Node childNode = Project.findFirstChildNamed(xml, childNodeName);
            if (childNode == null) continue;
            xml.remove(childNode);
        }
        xml.appendNode((Object)"name", (Object)Strings.nullToEmpty((String)this.name));
        xml.appendNode((Object)"comment", (Object)Strings.nullToEmpty((String)this.comment));
        this.addReferencedProjectsToXml();
        this.addNaturesToXml();
        this.addBuildSpecToXml();
        this.addLinkedResourcesToXml();
        this.addResourceFiltersToXml();
    }

    private void addReferencedProjectsToXml() {
        Node referencedProjectsNode = this.getXml().appendNode((Object)"projects");
        for (String projectName : this.referencedProjects) {
            referencedProjectsNode.appendNode((Object)"project", (Object)projectName);
        }
    }

    private void addNaturesToXml() {
        Node naturesNode = this.getXml().appendNode((Object)"natures");
        for (String nature : this.natures) {
            naturesNode.appendNode((Object)"nature", (Object)nature);
        }
    }

    private void addBuildSpecToXml() {
        Node buildSpec = this.getXml().appendNode((Object)"buildSpec");
        for (BuildCommand command : this.buildCommands) {
            Node commandNode = buildSpec.appendNode((Object)"buildCommand");
            commandNode.appendNode((Object)"name", (Object)command.getName());
            Node argumentsNode = commandNode.appendNode((Object)"arguments");
            for (Map.Entry<String, String> argument : command.getArguments().entrySet()) {
                Node dictionaryNode = argumentsNode.appendNode((Object)"dictionary");
                dictionaryNode.appendNode((Object)"key", (Object)argument.getKey());
                dictionaryNode.appendNode((Object)"value", (Object)argument.getValue());
            }
        }
    }

    private void addLinkedResourcesToXml() {
        Node parent = this.getXml().appendNode((Object)"linkedResources");
        for (Link link : this.linkedResources) {
            Node linkNode = parent.appendNode((Object)"link");
            linkNode.appendNode((Object)"name", (Object)link.getName());
            linkNode.appendNode((Object)"type", (Object)link.getType());
            if (!Strings.isNullOrEmpty((String)link.getLocation())) {
                linkNode.appendNode((Object)"location", (Object)link.getLocation());
            }
            if (Strings.isNullOrEmpty((String)link.getLocationUri())) continue;
            linkNode.appendNode((Object)"locationURI", (Object)link.getLocationUri());
        }
    }

    private void addResourceFiltersToXml() {
        Node parent = this.getXml().appendNode((Object)"filteredResources");
        int filterId = 1;
        for (ResourceFilter resourceFilter : this.resourceFilters) {
            Node filterNode = parent.appendNode((Object)"filter");
            filterNode.appendNode((Object)"id", (Object)filterId++);
            int type = this.getResourceFilterType(resourceFilter);
            filterNode.appendNode((Object)"type", (Object)type);
            filterNode.appendNode((Object)"name");
            this.addResourceFilterMatcherToXml(filterNode, resourceFilter.getMatcher());
        }
    }

    private void addResourceFilterMatcherToXml(Node parent, ResourceFilterMatcher matcher) {
        Node matcherNode = parent.appendNode((Object)"matcher");
        matcherNode.appendNode((Object)"id", (Object)matcher.getId());
        if (!Strings.isNullOrEmpty((String)matcher.getArguments())) {
            matcherNode.appendNode((Object)"arguments", (Object)matcher.getArguments());
        } else if (!matcher.getChildren().isEmpty()) {
            Node argumentsNode = matcherNode.appendNode((Object)"arguments");
            for (ResourceFilterMatcher m : matcher.getChildren()) {
                this.addResourceFilterMatcherToXml(argumentsNode, m);
            }
        }
    }

    private int getResourceFilterType(ResourceFilter resourceFilter) {
        int type = 0;
        switch (resourceFilter.getType()) {
            case INCLUDE_ONLY: {
                type |= 1;
                break;
            }
            case EXCLUDE_ALL: {
                type |= 2;
            }
        }
        switch (resourceFilter.getAppliesTo()) {
            case FILES: {
                type |= 4;
                break;
            }
            case FOLDERS: {
                type |= 8;
                break;
            }
            case FILES_AND_FOLDERS: {
                type |= 0xC;
            }
        }
        if (resourceFilter.isRecursive()) {
            type |= 0x10;
        }
        return type;
    }

    private ResourceFilterAppliesTo resourceFilterTypeBitmaskToAppliesTo(int type) {
        Preconditions.checkArgument((type >= 0 ? 1 : 0) != 0);
        if ((type & 8) != 0 && (type & 4) != 0) {
            return ResourceFilterAppliesTo.FILES_AND_FOLDERS;
        }
        if ((type & 8) != 0) {
            return ResourceFilterAppliesTo.FOLDERS;
        }
        if ((type & 4) != 0) {
            return ResourceFilterAppliesTo.FILES;
        }
        return null;
    }

    private ResourceFilterType resourceFilterTypeBitmaskToType(int type) {
        Preconditions.checkArgument((type >= 0 ? 1 : 0) != 0);
        if ((type & 1) != 0) {
            return ResourceFilterType.INCLUDE_ONLY;
        }
        if ((type & 2) != 0) {
            return ResourceFilterType.EXCLUDE_ALL;
        }
        return null;
    }

    private boolean isResourceFilterTypeBitmaskRecursive(int type) {
        Preconditions.checkArgument((type >= 0 ? 1 : 0) != 0);
        return (type & 0x10) != 0;
    }

    private ResourceFilterMatcher readResourceFilterMatcher(Node matcherNode) {
        if (matcherNode == null) {
            return null;
        }
        Node idNode = Project.findFirstChildNamed(matcherNode, "id");
        Node argumentsNode = Project.findFirstChildNamed(matcherNode, "arguments");
        String arguments = null;
        LinkedHashSet children = Sets.newLinkedHashSet();
        if (argumentsNode != null && Project.findFirstChildNamed(argumentsNode, "matcher") != null) {
            for (Node childMatcherNode : Project.getChildren(argumentsNode, "matcher")) {
                ResourceFilterMatcher childMatcher = this.readResourceFilterMatcher(childMatcherNode);
                if (childMatcher == null) continue;
                children.add(childMatcher);
            }
        } else {
            arguments = argumentsNode != null ? argumentsNode.text() : null;
        }
        return new DefaultResourceFilterMatcher(idNode != null ? idNode.text() : null, arguments, children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equal(this.buildCommands, project.buildCommands) && Objects.equal((Object)this.comment, (Object)project.comment) && Objects.equal(this.linkedResources, project.linkedResources) && Objects.equal(this.resourceFilters, project.resourceFilters) && Objects.equal((Object)this.name, (Object)project.name) && Objects.equal(this.natures, project.natures) && Objects.equal(this.referencedProjects, project.referencedProjects);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.referencedProjects != null ? this.referencedProjects.hashCode() : 0);
        result = 31 * result + (this.natures != null ? this.natures.hashCode() : 0);
        result = 31 * result + (this.buildCommands != null ? this.buildCommands.hashCode() : 0);
        result = 31 * result + (this.linkedResources != null ? this.linkedResources.hashCode() : 0);
        result = 31 * result + (this.resourceFilters != null ? this.resourceFilters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Project{name='" + this.name + "', comment='" + this.comment + "', referencedProjects=" + this.referencedProjects + ", natures=" + this.natures + ", buildCommands=" + this.buildCommands + ", linkedResources=" + this.linkedResources + ", resourceFilters=" + this.resourceFilters + "}";
    }
}

