/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.execution.TaskSelector;
import org.gradle.util.internal.NameMatcher;

public class DefaultTaskSelector
implements TaskSelector {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskSelector.class);
    private final TaskNameResolver taskNameResolver;
    private final ProjectConfigurer configurer;

    public DefaultTaskSelector(TaskNameResolver taskNameResolver, ProjectConfigurer configurer) {
        this.taskNameResolver = taskNameResolver;
        this.configurer = configurer;
    }

    @Override
    public Spec<Task> getFilter(TaskSelector.SelectionContext context, ProjectState project, String taskName, boolean includeSubprojects) {
        if (includeSubprojects) {
            this.configurer.configure(project.getMutableModel());
            if (this.taskNameResolver.tryFindUnqualifiedTaskCheaply(taskName, project.getMutableModel())) {
                return new TaskPathSpec(project.getMutableModel(), taskName);
            }
        }
        Set<Task> selectedTasks = this.getSelection(context, project, taskName, includeSubprojects).getTasks();
        return element -> !selectedTasks.contains(element);
    }

    @Override
    public TaskSelection getSelection(TaskSelector.SelectionContext context, ProjectState targetProject, String taskName, boolean includeSubprojects) {
        if (!includeSubprojects) {
            this.configurer.configure(targetProject.getMutableModel());
        } else {
            this.configurer.configureHierarchy(targetProject.getMutableModel());
        }
        TaskSelectionResult tasks = this.taskNameResolver.selectWithName(taskName, targetProject.getMutableModel(), includeSubprojects);
        if (tasks != null) {
            LOGGER.info("Task name matched '{}'", (Object)taskName);
            return new TaskSelection(targetProject.getProjectPath().getPath(), taskName, tasks);
        }
        NameMatcher matcher = new NameMatcher();
        Map<String, TaskSelectionResult> tasksByName = this.taskNameResolver.selectAll(targetProject.getMutableModel(), includeSubprojects);
        String actualName = matcher.find(taskName, tasksByName.keySet());
        if (actualName != null) {
            LOGGER.info("Abbreviated task name '{}' matched '{}'", (Object)taskName, (Object)actualName);
            return new TaskSelection(targetProject.getProjectPath().getPath(), taskName, tasksByName.get(actualName));
        }
        String searchContext = includeSubprojects && !targetProject.getChildProjects().isEmpty() ? targetProject.getDisplayName() + " and its subprojects" : targetProject.getDisplayName().getDisplayName();
        if (context.getOriginalPath().getPath().equals(taskName)) {
            throw new TaskSelectionException(matcher.formatErrorMessage("Task", searchContext));
        }
        throw new TaskSelectionException(String.format("Cannot locate %s that match '%s' as %s", context.getType(), context.getOriginalPath(), matcher.formatErrorMessage("task", searchContext)));
    }

    private static class TaskPathSpec
    implements Spec<Task> {
        private final ProjectInternal targetProject;
        private final String taskName;

        public TaskPathSpec(ProjectInternal targetProject, String taskName) {
            this.targetProject = targetProject;
            this.taskName = taskName;
        }

        public boolean isSatisfiedBy(Task element) {
            if (!element.getName().equals(this.taskName)) {
                return true;
            }
            for (Project current = element.getProject(); current != null; current = current.getParent()) {
                if (!current.equals(this.targetProject)) continue;
                return false;
            }
            return true;
        }
    }
}

