/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jansi.win;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.function.IntConsumer;
import org.jetbrains.kotlin.org.fusesource.jansi.WindowsAnsiOutputStream;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.Kernel32;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.WindowsSupport;
import org.jetbrains.kotlin.org.jline.terminal.Cursor;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jetbrains.kotlin.org.jline.utils.InfoCmp;

public class JansiWinSysTerminal
extends AbstractWindowsTerminal {
    public JansiWinSysTerminal(String name2, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(new WindowsAnsiOutputStream(new FileOutputStream(FileDescriptor.out)), name2, nativeSignals, signalHandler);
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        return WindowsSupport.getConsoleMode();
    }

    @Override
    protected void setConsoleMode(int mode) {
        WindowsSupport.setConsoleMode(mode);
    }

    @Override
    public Size getSize() {
        Size size = new Size();
        size.setColumns(WindowsSupport.getWindowsTerminalWidth());
        size.setRows(WindowsSupport.getWindowsTerminalHeight());
        return size;
    }

    @Override
    protected byte[] readConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD[] events = WindowsSupport.readConsoleInput(1);
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            boolean isAlt;
            Kernel32.KEY_EVENT_RECORD keyEvent = event.keyEvent;
            int altState = Kernel32.KEY_EVENT_RECORD.LEFT_ALT_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_ALT_PRESSED;
            int ctrlState = Kernel32.KEY_EVENT_RECORD.LEFT_CTRL_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_CTRL_PRESSED;
            boolean bl = isAlt = (keyEvent.controlKeyState & altState) != 0 && (keyEvent.controlKeyState & ctrlState) == 0;
            if (keyEvent.keyDown) {
                if (keyEvent.uchar > '\u0000') {
                    boolean shiftPressed;
                    boolean bl2 = shiftPressed = (keyEvent.controlKeyState & Kernel32.KEY_EVENT_RECORD.SHIFT_PRESSED) != 0;
                    if (keyEvent.uchar == '\t' && shiftPressed) {
                        sb.append(this.getSequence(InfoCmp.Capability.key_btab));
                        continue;
                    }
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(keyEvent.uchar);
                    continue;
                }
                String escapeSequence = this.getEscapeSequence(keyEvent.keyCode);
                if (escapeSequence == null) continue;
                for (int k = 0; k < keyEvent.repeatCount; ++k) {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(escapeSequence);
                }
                continue;
            }
            if (keyEvent.keyCode != 18 || keyEvent.uchar <= '\u0000') continue;
            sb.append(keyEvent.uchar);
        }
        return sb.toString().getBytes();
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        long console = Kernel32.GetStdHandle(Kernel32.STD_OUTPUT_HANDLE);
        if (Kernel32.GetConsoleScreenBufferInfo(console, info) == 0) {
            throw new IOError(new IOException("Could not get the cursor position: " + WindowsSupport.getLastErrorMessage()));
        }
        return new Cursor(info.cursorPosition.x, info.cursorPosition.y);
    }

    public void disableScrolling() {
        this.strings.remove((Object)InfoCmp.Capability.insert_line);
        this.strings.remove((Object)InfoCmp.Capability.parm_insert_line);
        this.strings.remove((Object)InfoCmp.Capability.delete_line);
        this.strings.remove((Object)InfoCmp.Capability.parm_delete_line);
    }
}

