/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Namer;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.cached.ExternalResourceFileStore;
import org.gradle.internal.resource.local.GroupedAndNamedUniqueFileStore;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

public class DefaultExternalResourceFileStore
extends GroupedAndNamedUniqueFileStore<String>
implements ExternalResourceFileStore {
    private static final int NUMBER_OF_GROUPING_DIRS = 1;
    public static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 2;
    private static final GroupedAndNamedUniqueFileStore.Grouper<String> GROUPER = new GroupedAndNamedUniqueFileStore.Grouper<String>(){

        public String determineGroup(String s) {
            return String.valueOf(Math.abs(s.hashCode()) % 100);
        }

        public int getNumberOfGroupingDirs() {
            return 1;
        }
    };
    private static final Namer<String> NAMER = s -> StringUtils.substringAfterLast((String)s, (String)"/");

    private DefaultExternalResourceFileStore(File baseDir, TemporaryFileProvider tmpProvider, FileAccessTimeJournal fileAccessTimeJournal, ChecksumService checksumService) {
        super(baseDir, tmpProvider, fileAccessTimeJournal, GROUPER, NAMER, checksumService);
    }

    @ServiceScope(value=Scopes.Build.class)
    public static class Factory {
        private final TemporaryFileProvider temporaryFileProvider;
        private final FileAccessTimeJournal fileAccessTimeJournal;
        private final ChecksumService checksumService;

        @Inject
        public Factory(TemporaryFileProvider temporaryFileProvider, FileAccessTimeJournal fileAccessTimeJournal, ChecksumService checksumService) {
            this.temporaryFileProvider = temporaryFileProvider;
            this.fileAccessTimeJournal = fileAccessTimeJournal;
            this.checksumService = checksumService;
        }

        public DefaultExternalResourceFileStore create(ArtifactCacheMetadata artifactCacheMetadata) {
            return new DefaultExternalResourceFileStore(artifactCacheMetadata.getExternalResourcesStoreDirectory(), this.temporaryFileProvider, this.fileAccessTimeJournal, this.checksumService);
        }
    }
}

