/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.gradle.api.attributes.Attribute;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ArrayValueSnapshot;
import org.gradle.internal.snapshot.impl.AttributeDefinitionSnapshot;
import org.gradle.internal.snapshot.impl.BooleanValueSnapshot;
import org.gradle.internal.snapshot.impl.EnumValueSnapshot;
import org.gradle.internal.snapshot.impl.FileValueSnapshot;
import org.gradle.internal.snapshot.impl.GradleSerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.HashCodeSnapshot;
import org.gradle.internal.snapshot.impl.ImmutableManagedValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshotSerializer;
import org.gradle.internal.snapshot.impl.IntegerValueSnapshot;
import org.gradle.internal.snapshot.impl.JavaSerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.ListValueSnapshot;
import org.gradle.internal.snapshot.impl.LongValueSnapshot;
import org.gradle.internal.snapshot.impl.ManagedValueSnapshot;
import org.gradle.internal.snapshot.impl.MapEntrySnapshot;
import org.gradle.internal.snapshot.impl.MapValueSnapshot;
import org.gradle.internal.snapshot.impl.NullValueSnapshot;
import org.gradle.internal.snapshot.impl.SetValueSnapshot;
import org.gradle.internal.snapshot.impl.ShortValueSnapshot;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;

public class SnapshotSerializer
extends AbstractSerializer<ValueSnapshot> {
    private static final int NULL_SNAPSHOT = 0;
    private static final int TRUE_SNAPSHOT = 1;
    private static final int FALSE_SNAPSHOT = 2;
    private static final int STRING_SNAPSHOT = 3;
    private static final int INTEGER_SNAPSHOT = 4;
    private static final int LONG_SNAPSHOT = 5;
    private static final int SHORT_SNAPSHOT = 6;
    private static final int FILE_SNAPSHOT = 7;
    private static final int ENUM_SNAPSHOT = 8;
    private static final int EMPTY_ARRAY_SNAPSHOT = 9;
    private static final int ARRAY_SNAPSHOT = 10;
    private static final int EMPTY_LIST_SNAPSHOT = 11;
    private static final int LIST_SNAPSHOT = 12;
    private static final int SET_SNAPSHOT = 13;
    private static final int MAP_SNAPSHOT = 14;
    private static final int MANAGED_SNAPSHOT = 15;
    private static final int IMMUTABLE_MANAGED_SNAPSHOT = 16;
    private static final int IMPLEMENTATION_SNAPSHOT = 17;
    private static final int HASH_SNAPSHOT = 18;
    private static final int ATTRIBUTE = 19;
    private static final int GRADLE_SERIALIZED_SNAPSHOT = 20;
    private static final int DEFAULT_SNAPSHOT = 21;
    private final HashCodeSerializer serializer = new HashCodeSerializer();
    private final Serializer<ImplementationSnapshot> implementationSnapshotSerializer = new ImplementationSnapshotSerializer();
    private final ClassLoaderHierarchyHasher classLoaderHasher;

    public SnapshotSerializer(ClassLoaderHierarchyHasher classLoaderHasher) {
        this.classLoaderHasher = classLoaderHasher;
    }

    public ValueSnapshot read(Decoder decoder) throws Exception {
        int type = decoder.readSmallInt();
        switch (type) {
            case 0: {
                return NullValueSnapshot.INSTANCE;
            }
            case 1: {
                return BooleanValueSnapshot.TRUE;
            }
            case 2: {
                return BooleanValueSnapshot.FALSE;
            }
            case 3: {
                return new StringValueSnapshot(decoder.readString());
            }
            case 4: {
                return new IntegerValueSnapshot(decoder.readInt());
            }
            case 5: {
                return new LongValueSnapshot(decoder.readLong());
            }
            case 6: {
                return new ShortValueSnapshot((short)decoder.readInt());
            }
            case 18: {
                return new HashCodeSnapshot(HashCode.fromBytes((byte[])decoder.readBinary()));
            }
            case 7: {
                return new FileValueSnapshot(decoder.readString());
            }
            case 8: {
                return new EnumValueSnapshot(decoder.readString(), decoder.readString());
            }
            case 9: {
                return ArrayValueSnapshot.EMPTY;
            }
            case 10: {
                int size = decoder.readSmallInt();
                ImmutableList<ValueSnapshot> arrayElements = this.readList(decoder, size);
                return new ArrayValueSnapshot(arrayElements);
            }
            case 11: {
                return ListValueSnapshot.EMPTY;
            }
            case 12: {
                int size = decoder.readSmallInt();
                ImmutableList<ValueSnapshot> listElements = this.readList(decoder, size);
                return new ListValueSnapshot(listElements);
            }
            case 13: {
                int size = decoder.readSmallInt();
                ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                for (int i = 0; i < size; ++i) {
                    setBuilder.add((Object)this.read(decoder));
                }
                return new SetValueSnapshot((ImmutableSet<ValueSnapshot>)setBuilder.build());
            }
            case 14: {
                int size = decoder.readSmallInt();
                ImmutableList.Builder mapBuilder = ImmutableList.builderWithExpectedSize((int)size);
                for (int i = 0; i < size; ++i) {
                    mapBuilder.add((Object)new MapEntrySnapshot((Object)this.read(decoder), (Object)this.read(decoder)));
                }
                return new MapValueSnapshot((ImmutableList<MapEntrySnapshot<ValueSnapshot>>)mapBuilder.build());
            }
            case 15: {
                String className = decoder.readString();
                ValueSnapshot state = this.read(decoder);
                return new ManagedValueSnapshot(className, state);
            }
            case 16: {
                String className = decoder.readString();
                String value = decoder.readNullableString();
                return new ImmutableManagedValueSnapshot(className, value);
            }
            case 17: {
                return (ValueSnapshot)this.implementationSnapshotSerializer.read(decoder);
            }
            case 19: {
                return new AttributeDefinitionSnapshot(Attribute.of((String)decoder.readString(), (Class)ClassLoaderUtils.classFromContextLoader((String)decoder.readString())), this.classLoaderHasher);
            }
            case 20: {
                return new GradleSerializedValueSnapshot(decoder.readBoolean() ? this.serializer.read(decoder) : null, decoder.readBinary());
            }
            case 21: {
                return new JavaSerializedValueSnapshot(decoder.readBoolean() ? this.serializer.read(decoder) : null, decoder.readBinary());
            }
        }
        throw new IllegalArgumentException("Don't know how to deserialize a snapshot with type tag " + type);
    }

    private ImmutableList<ValueSnapshot> readList(Decoder decoder, int size) throws Exception {
        ImmutableList.Builder arrayElements = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            arrayElements.add((Object)this.read(decoder));
        }
        return arrayElements.build();
    }

    public void write(Encoder encoder, ValueSnapshot snapshot) throws Exception {
        if (snapshot == NullValueSnapshot.INSTANCE) {
            encoder.writeSmallInt(0);
        } else if (snapshot instanceof StringValueSnapshot) {
            StringValueSnapshot stringSnapshot = (StringValueSnapshot)snapshot;
            encoder.writeSmallInt(3);
            encoder.writeString((CharSequence)stringSnapshot.getValue());
        } else if (snapshot instanceof ListValueSnapshot) {
            ListValueSnapshot listSnapshot = (ListValueSnapshot)snapshot;
            if (listSnapshot.getElements().isEmpty()) {
                encoder.writeSmallInt(11);
            } else {
                encoder.writeSmallInt(12);
                encoder.writeSmallInt(listSnapshot.getElements().size());
                for (ValueSnapshot valueSnapshot : listSnapshot.getElements()) {
                    this.write(encoder, valueSnapshot);
                }
            }
        } else if (snapshot == BooleanValueSnapshot.TRUE) {
            encoder.writeSmallInt(1);
        } else if (snapshot == BooleanValueSnapshot.FALSE) {
            encoder.writeSmallInt(2);
        } else if (snapshot instanceof IntegerValueSnapshot) {
            IntegerValueSnapshot integerSnapshot = (IntegerValueSnapshot)snapshot;
            encoder.writeSmallInt(4);
            encoder.writeInt(((Integer)integerSnapshot.getValue()).intValue());
        } else if (snapshot instanceof LongValueSnapshot) {
            LongValueSnapshot longSnapshot = (LongValueSnapshot)snapshot;
            encoder.writeSmallInt(5);
            encoder.writeLong(((Long)longSnapshot.getValue()).longValue());
        } else if (snapshot instanceof ShortValueSnapshot) {
            ShortValueSnapshot shortSnapshot = (ShortValueSnapshot)snapshot;
            encoder.writeSmallInt(6);
            encoder.writeInt((int)((Short)shortSnapshot.getValue()).shortValue());
        } else if (snapshot instanceof HashCodeSnapshot) {
            HashCodeSnapshot hashSnapshot = (HashCodeSnapshot)snapshot;
            encoder.writeSmallInt(18);
            encoder.writeBinary(((HashCode)hashSnapshot.getValue()).toByteArray());
        } else if (snapshot instanceof FileValueSnapshot) {
            FileValueSnapshot fileSnapshot = (FileValueSnapshot)snapshot;
            encoder.writeSmallInt(7);
            encoder.writeString((CharSequence)fileSnapshot.getValue());
        } else if (snapshot instanceof EnumValueSnapshot) {
            EnumValueSnapshot enumSnapshot = (EnumValueSnapshot)snapshot;
            encoder.writeSmallInt(8);
            encoder.writeString((CharSequence)enumSnapshot.getClassName());
            encoder.writeString((CharSequence)enumSnapshot.getName());
        } else if (snapshot instanceof SetValueSnapshot) {
            SetValueSnapshot setSnapshot = (SetValueSnapshot)snapshot;
            encoder.writeSmallInt(13);
            encoder.writeSmallInt(setSnapshot.getElements().size());
            for (ValueSnapshot valueSnapshot : setSnapshot.getElements()) {
                this.write(encoder, valueSnapshot);
            }
        } else if (snapshot instanceof ImplementationSnapshot) {
            ImplementationSnapshot implementationSnapshot = (ImplementationSnapshot)snapshot;
            encoder.writeSmallInt(17);
            this.implementationSnapshotSerializer.write(encoder, (Object)implementationSnapshot);
        } else if (snapshot instanceof AttributeDefinitionSnapshot) {
            AttributeDefinitionSnapshot valueSnapshot = (AttributeDefinitionSnapshot)snapshot;
            encoder.writeSmallInt(19);
            encoder.writeString((CharSequence)((Attribute)valueSnapshot.getValue()).getName());
            encoder.writeString((CharSequence)((Attribute)valueSnapshot.getValue()).getType().getName());
        } else if (snapshot instanceof GradleSerializedValueSnapshot) {
            GradleSerializedValueSnapshot valueSnapshot = (GradleSerializedValueSnapshot)snapshot;
            encoder.writeSmallInt(20);
            if (valueSnapshot.getImplementationHash() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.serializer.write(encoder, valueSnapshot.getImplementationHash());
            }
            encoder.writeBinary(valueSnapshot.getValue());
        } else if (snapshot instanceof JavaSerializedValueSnapshot) {
            JavaSerializedValueSnapshot valueSnapshot = (JavaSerializedValueSnapshot)snapshot;
            encoder.writeSmallInt(21);
            if (valueSnapshot.getImplementationHash() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.serializer.write(encoder, valueSnapshot.getImplementationHash());
            }
            encoder.writeBinary(valueSnapshot.getValue());
        } else if (snapshot instanceof MapValueSnapshot) {
            MapValueSnapshot mapSnapshot = (MapValueSnapshot)snapshot;
            encoder.writeSmallInt(14);
            encoder.writeSmallInt(mapSnapshot.getEntries().size());
            for (MapEntrySnapshot entry : mapSnapshot.getEntries()) {
                this.write(encoder, (ValueSnapshot)entry.getKey());
                this.write(encoder, (ValueSnapshot)entry.getValue());
            }
        } else if (snapshot instanceof ArrayValueSnapshot) {
            ArrayValueSnapshot arraySnapshot = (ArrayValueSnapshot)snapshot;
            if (arraySnapshot.getElements().isEmpty()) {
                encoder.writeSmallInt(9);
            } else {
                encoder.writeSmallInt(10);
                encoder.writeSmallInt(arraySnapshot.getElements().size());
                for (ValueSnapshot valueSnapshot : arraySnapshot.getElements()) {
                    this.write(encoder, valueSnapshot);
                }
            }
        } else if (snapshot instanceof ImmutableManagedValueSnapshot) {
            encoder.writeSmallInt(16);
            ImmutableManagedValueSnapshot valueSnapshot = (ImmutableManagedValueSnapshot)snapshot;
            encoder.writeString((CharSequence)valueSnapshot.getClassName());
            encoder.writeNullableString((CharSequence)valueSnapshot.getValue());
        } else if (snapshot instanceof ManagedValueSnapshot) {
            encoder.writeSmallInt(15);
            ManagedValueSnapshot managedTypeSnapshot = (ManagedValueSnapshot)snapshot;
            encoder.writeString((CharSequence)managedTypeSnapshot.getClassName());
            this.write(encoder, (ValueSnapshot)managedTypeSnapshot.getState());
        } else {
            throw new IllegalArgumentException("Don't know how to serialize a value of type " + snapshot.getClass().getSimpleName());
        }
    }
}

