/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class NestedValidationUtil {
    private static final ImmutableSet<Class<?>> SUPPORTED_KEY_TYPES = ImmutableSet.of(Enum.class, Integer.class, String.class);

    public static void validateBeanType(TypeValidationContext validationContext, String propertyName, Class<?> beanType) {
        Optional<String> unsupportedReason = NestedValidationUtil.getUnsupportedReason(beanType);
        unsupportedReason.ifPresent(reason -> validationContext.visitPropertyProblem((Action<? super PropertyProblemBuilder>)((Action)problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.NESTED_TYPE_UNSUPPORTED)).reportAs(Severity.WARNING)).forProperty(propertyName).withDescription(() -> "with nested type '" + beanType.getName() + "' is not supported")).happensBecause((String)reason)).addPossibleSolution("Use a different input annotation if type is not a bean")).addPossibleSolution("Use a different package that doesn't conflict with standard Java or Kotlin types for custom types")).documentedAt("validation_problems", "unsupported_nested_type"))));
    }

    private static Optional<String> getUnsupportedReason(Class<?> type) {
        if (type.getName().startsWith("java.") || type.getName().startsWith("javax.")) {
            return Optional.of("Type is in 'java.*' or 'javax.*' package that are reserved for standard Java API types");
        }
        if (type.getName().startsWith("kotlin.")) {
            return Optional.of("Type is in 'kotlin.*' package that is reserved for Kotlin stdlib types");
        }
        if (type.getName().startsWith("groovy.lang.GString")) {
            return Optional.of("Groovy's GString type is not supported as a nested type");
        }
        return Optional.empty();
    }

    public static void validateKeyType(TypeValidationContext validationContext, String propertyName, Class<?> keyType) {
        if (!SUPPORTED_KEY_TYPES.contains(keyType)) {
            validationContext.visitPropertyProblem((Action<? super PropertyProblemBuilder>)((Action)problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.NESTED_MAP_UNSUPPORTED_KEY_TYPE)).reportAs(Severity.WARNING)).forProperty(propertyName).withDescription(() -> "where key of nested map is of type '" + keyType.getName() + "'")).happensBecause("Key of nested map must be one of the following types: " + NestedValidationUtil.getSupportedKeyTypes())).addPossibleSolution("Change type of key to one of the following types: " + NestedValidationUtil.getSupportedKeyTypes())).documentedAt("validation_problems", "unsupported_key_type_of_nested_map")));
        }
    }

    private static String getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES.stream().map(cls -> "'" + cls.getSimpleName() + "'").collect(Collectors.joining(", "));
    }
}

