/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPoolingSPListener
implements SPListener {
    private static final Logger logger = Logger.getLogger(AbstractPoolingSPListener.class);
    private final Map<SPObject, Integer> inTransactionMap = new IdentityHashMap<SPObject, Integer>();
    private final Map<SPObject, List<Object>> eventMap = new IdentityHashMap<SPObject, List<Object>>();
    private final boolean errorOnDanglingCommit;

    @Override
    public final void transactionEnded(TransactionEvent e) {
        if (this.errorOnDanglingCommit && this.inTransactionMap.get(e.getSource()) == null) {
            throw new IllegalStateException("An end transaction for object " + e.getSource() + " of type " + e.getSource().getClass() + " was called while it was " + "not in a transaction.");
        }
        if (!this.errorOnDanglingCommit && this.inTransactionMap.get(e.getSource()) == null) {
            return;
        }
        Integer lastTransactionCount = this.inTransactionMap.get(e.getSource());
        logger.debug((Object)("Transaction count on " + this + " for:" + e.getSource() + ": " + this.inTransactionMap.get((SPObject)e.getSource())));
        Integer nestedTransactionCount = lastTransactionCount - 1;
        if (nestedTransactionCount < 0) {
            throw new IllegalStateException("The transaction count was not removed properly.");
        }
        if (nestedTransactionCount > 0) {
            this.inTransactionMap.put((SPObject)e.getSource(), nestedTransactionCount);
            this.transactionEndedImpl(e);
        } else {
            this.inTransactionMap.remove(e.getSource());
            if (this.eventMap.get(e.getSource()) != null) {
                ArrayList eventsForSource = new ArrayList(this.eventMap.get(e.getSource()));
                this.eventMap.remove(e.getSource());
                for (Object evt : eventsForSource) {
                    if (evt instanceof PropertyChangeEvent) {
                        this.propertyChangeImpl((PropertyChangeEvent)evt);
                        continue;
                    }
                    if (evt instanceof SPChildEvent) {
                        SPChildEvent childEvent = (SPChildEvent)evt;
                        if (childEvent.getType().equals((Object)SPChildEvent.EventType.ADDED)) {
                            this.childAddedImpl(childEvent);
                            continue;
                        }
                        if (childEvent.getType().equals((Object)SPChildEvent.EventType.REMOVED)) {
                            this.childRemovedImpl(childEvent);
                            continue;
                        }
                        throw new IllegalStateException("Unknown wabit child event of type " + (Object)((Object)childEvent.getType()));
                    }
                    throw new IllegalStateException("Unknown event type " + evt.getClass());
                }
            }
            this.transactionEndedImpl(e);
            this.finalCommitImpl(e);
        }
    }

    public AbstractPoolingSPListener() {
        this.errorOnDanglingCommit = true;
    }

    public AbstractPoolingSPListener(boolean errorOnDanglingCommit) {
        this.errorOnDanglingCommit = errorOnDanglingCommit;
    }

    protected void transactionEndedImpl(TransactionEvent e) {
    }

    protected void finalCommitImpl(TransactionEvent e) {
    }

    @Override
    public final void transactionRollback(TransactionEvent e) {
        this.inTransactionMap.remove(e.getSource());
        this.eventMap.remove(e.getSource());
        this.transactionRollbackImpl(e);
    }

    protected void transactionRollbackImpl(TransactionEvent e) {
    }

    @Override
    public final void transactionStarted(TransactionEvent e) {
        Integer transactionCount = this.inTransactionMap.get(e.getSource());
        if (transactionCount == null) {
            this.inTransactionMap.put((SPObject)e.getSource(), 1);
        } else {
            this.inTransactionMap.put((SPObject)e.getSource(), transactionCount + 1);
        }
        logger.debug((Object)("Transaction count on " + this + " for:" + e.getSource() + ": " + this.inTransactionMap.get((SPObject)e.getSource())));
        this.transactionStartedImpl(e);
    }

    protected void transactionStartedImpl(TransactionEvent e) {
    }

    @Override
    public final void childAdded(SPChildEvent e) {
        if (this.inTransactionMap.get(e.getSource()) != null && this.inTransactionMap.get(e.getSource()) > 0) {
            List<Object> events = this.eventMap.get(e.getSource());
            if (events == null) {
                events = new ArrayList<Object>();
                this.eventMap.put(e.getSource(), events);
            }
            events.add(e);
        } else {
            this.childAddedImpl(e);
        }
    }

    protected void childAddedImpl(SPChildEvent e) {
    }

    @Override
    public final void childRemoved(SPChildEvent e) {
        if (this.inTransactionMap.get(e.getSource()) != null && this.inTransactionMap.get(e.getSource()) > 0) {
            List<Object> events = this.eventMap.get(e.getSource());
            if (events == null) {
                events = new ArrayList<Object>();
                this.eventMap.put(e.getSource(), events);
            }
            events.add(e);
        } else {
            this.childRemovedImpl(e);
        }
    }

    protected void childRemovedImpl(SPChildEvent e) {
    }

    @Override
    public final void propertyChanged(PropertyChangeEvent evt) {
        if (this.inTransactionMap.get(evt.getSource()) != null && this.inTransactionMap.get(evt.getSource()) > 0) {
            List<Object> events = this.eventMap.get(evt.getSource());
            if (events == null) {
                events = new ArrayList<Object>();
                this.eventMap.put((SPObject)evt.getSource(), events);
            }
            events.add(evt);
        } else {
            this.propertyChangeImpl(evt);
        }
    }

    protected void propertyChangeImpl(PropertyChangeEvent evt) {
    }
}

